% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_annual_frequencies.R
\name{compute_annual_frequencies}
\alias{compute_annual_frequencies}
\title{Perform an annual low or high-flow frequency analysis}
\usage{
compute_annual_frequencies(
  data,
  dates = Date,
  values = Value,
  station_number,
  roll_days = c(1, 3, 7, 30),
  roll_align = "right",
  use_max = FALSE,
  use_log = FALSE,
  prob_plot_position = c("weibull", "median", "hazen"),
  prob_scale_points = c(0.9999, 0.999, 0.99, 0.9, 0.5, 0.2, 0.1, 0.02, 0.01, 0.001,
    0.0001),
  fit_distr = c("PIII", "weibull"),
  fit_distr_method = ifelse(fit_distr == "PIII", "MOM", "MLE"),
  fit_quantiles = c(0.975, 0.99, 0.98, 0.95, 0.9, 0.8, 0.5, 0.2, 0.1, 0.05, 0.01),
  plot_curve = TRUE,
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  ignore_missing = FALSE,
  allowed_missing = ifelse(ignore_missing, 100, 0)
)
}
\arguments{
\item{data}{A data frame of daily data that contains columns of dates and flow values. Groupings and the \code{groups} argument
are not used for this function (i.e. station numbers). Leave blank if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Default \code{1}.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
(\code{'left'}), last (\code{'right'}), or middle (\code{'center'}) day of the rolling n-day group of observations. 
Default \code{'right'}.}

\item{use_max}{Logical value to indicate using maximums rather than the minimums for analysis. Default \code{FALSE}.}

\item{use_log}{Logical value to indicate log-scale transforming of flow data before analysis. Default \code{FALSE}.}

\item{prob_plot_position}{Character string indicating the plotting positions used in the frequency plots, one of \code{'weibull'},
\code{'median'}, or \code{'hazen'}. Points are plotted against  (i-a)/(n+1-a-b) where \code{i} is the rank of the value; \code{n} is the 
sample size and \code{a} and \code{b} are defined as: (a=0, b=0) for Weibull plotting positions; (a=.2; b=.3) for Median 
plotting positions; and (a=.5; b=.5) for Hazen plotting positions. Default \code{'weibull'}.}

\item{prob_scale_points}{Numeric vector of probabilities to be plotted along the X axis in the frequency plot. Inverse of 
return period. Default \code{c(.9999, .999, .99, .9, .5, .2, .1, .02, .01, .001, .0001)}.}

\item{fit_distr}{Character string identifying the distribution to fit annual data, one of \code{'PIII'} (Log Pearson Type III)
or \code{'weibull'} (Weibull) distributions. Default \code{'PIII'}.}

\item{fit_distr_method}{Character string identifying the method used to fit the distribution, one of \code{'MOM'} (method of
moments) or \code{'MLE'} (maximum likelihood estimation). Selected as \code{'MOM'} if \code{fit_distr ='PIII'} (default) or 
\code{'MLE'} if \code{fit_distr = 'weibull'}.}

\item{fit_quantiles}{Numeric vector of quantiles to be estimated from the fitted distribution. 
Default \code{c(.975, .99, .98, .95, .90, .80, .50, .20, .10, .05, .01)}.}

\item{plot_curve}{Logical value to indicate plotting the computed curve on the probability plot. Default \code{TRUE}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{months}{Numeric vector of months to include in analysis (e.g. \code{6:8} for Jun-Aug). Leave blank to summarize 
all months (default \code{1:12}).}

\item{ignore_missing}{Logical value indicating whether dates with missing values should be included in the calculation. If
\code{TRUE} then a statistic will be calculated regardless of missing dates. If \code{FALSE} then only those statistics from
time periods with no missing dates will be returned. Default \code{FALSE}.}

\item{allowed_missing}{Numeric value between 0 and 100 indicating the \strong{percentage} of missing dates allowed to be
included to calculate a statistic (0 to 100 percent). If \code{'ignore_missing = FALSE'} then it defaults to \code{0} (zero missing dates allowed),
if \code{'ignore_missing = TRUE'} then it defaults to \code{100} (any missing dates allowed); consistent with 
\code{ignore_missing} usage. Supersedes \code{ignore_missing} when used.}
}
\value{
A list with the following elements:
  \item{Freq_Analysis_Data}{Data frame with computed annual summary statistics used in analysis.}
  \item{Freq_Plot_Data}{Data frame with co-ordinates used in frequency plot.}
  \item{Freq_Plot}{ggplot2 object with frequency plot.}
  \item{Freq_Fitting}{List of fitted objects from fitdistrplus.}
  \item{Freq_Fitted_Quantiles}{Data frame with fitted quantiles.}
}
\description{
Performs a flow volume frequency analysis on annual statistics from a daily streamflow data set. Defaults to a low 
   flow frequency analysis using annual minimums. Set \code{use_max = TRUE} for annual high flow frequency analyses. Calculates 
   statistics from all values, unless specified. Function will calculate using all values in 'Values' column (no grouped analysis). 
   Analysis methodology replicates that from \href{https://www.hec.usace.army.mil/software/hec-ssp/}{HEC-SSP}. Returns a list of
   tibbles and plots.
}
\examples{
\dontrun{

# Working examples (see arguments for further analysis options):

# Compute an annual frequency analysis using default arguments
results <- compute_annual_frequencies(station_number = "08NM116",
                                      start_year = 1980,
                                      end_year = 2010)
                           
# Compute an annual frequency analysis using default arguments (as listed)
results <- compute_annual_frequencies(station_number = "08NM116",
                                      roll_days = c(1,3,7,30),
                                      start_year = 1980,
                                      end_year = 2010,
                                      prob_plot_position = "weibull",
                                      prob_scale_points = c(.9999, .999, .99, .9, .5, 
                                      .2, .1, .02, .01, .001, .0001),
                                      fit_distr = "PIII",
                                      fit_distr_method = "MOM")
                                      
# Compute a 7-day annual frequency analysis with "median" plotting positions
# and fitting the data to a weibull distribution (not default PIII)
results <- compute_annual_frequencies(station_number = "08NM116",
                                      roll_days = 7,
                                      start_year = 1980,
                                      end_year = 2010,
                                      prob_plot_position = "median",
                                      fit_distr = "weibull")
               
}            
}
\seealso{
\code{\link{compute_frequency_analysis}}
}
