% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_got_data.R
\name{get_got_data}
\alias{get_got_data}
\title{Generate simulated data as described in Gow, Ormazabal and Taylor (2010).}
\usage{
get_got_data(N = 400, T = 20, Xvol, Evol, rho_X, rho_E)
}
\arguments{
\item{N}{Number of firms}

\item{T}{Number of years}

\item{Xvol}{Cross-sectional correlation of \emph{X}}

\item{Evol}{Cross-sectional correlation of errors}

\item{rho_X}{Autocorrelation coefficient for firm-effect portion of \emph{X}}

\item{rho_E}{Autocorrelation coefficient for firm-effect portion of epsilon}
}
\value{
tibble
}
\description{
Function to generate simulated panel data as described in Gow, Ormazabal and
Taylor (2010).
}
\examples{
set.seed(2021)
test <- get_got_data(N = 500, T = 10, Xvol = 0.75,
                     Evol = 0.75, rho_X = 0.5, rho_E = 0.5)
test
}
