% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readARFF.R
\name{readARFF}
\alias{readARFF}
\title{Read ARFF file into data.frame.}
\usage{
readARFF(path, data.reader = "readr", tmp.file = tempfile(),
  convert.to.logicals = TRUE, show.info = TRUE, ...)
}
\arguments{
\item{path}{[\code{character(1)}]\cr
Path to ARFF file with read access.}

\item{data.reader}{[\code{character(1)}]\cr
Package back-end to parse ARFF data section with.
At the moment only \code{readr} is supported.
Default is \dQuote{readr}.}

\item{tmp.file}{[\code{character(1)}]\cr
The ARFF file must be preprocessed a bit, before it can be fed to the \code{data.reader}.
Path to TEMP output file, where this result is stored.
The file is deleted on exit.
Default is \code{tempfile()}.}

\item{convert.to.logicals}{[\code{logical(1)}]\cr
Should factors with values T or F be converted to logicals? (RWeka does this by default).
Default is \code{TRUE}.}

\item{show.info}{[\code{logical(1)}]\cr
Default is \code{TRUE}}

\item{...}{[any]
Further parameters passed to \code{\link[readr]{read_delim}}.}
}
\value{
[\code{data.frame}].
}
\description{
Implementation of a fast \href{http://www.cs.waikato.ac.nz/ml/weka/arff.html}{ARFF}
parser that produces consistent results compared to the reference implementation
in \pkg{RWeka}. The \dQuote{DATA} section is read with \code{\link[readr]{read_delim}}.
}
\details{
ARFF parsers are already available in package RWeka in \code{\link[RWeka]{read.arff}}
and package \code{foreign} in \code{\link[foreign]{read.arff}}. The RWeka parser
requires \code{Java} and \code{rJava}, a dependency which is notoriously hard to
configure for users in R. It is also quite slow. The parser in foreign in written
in pure R, slow and not fully consistent with the reference implementation in \code{RWeka}.
}
\note{
\itemize{
  \item{Integer feature columns in ARFF files are parsed as numeric columns into R.}
  \item{Sparse ARFF format is currently unsupported. The function will produce an
  informative error message in that case.}
  \item{ARFF attributes of type \dQuote{relational}, e.g., for multi-instance data,
  are currently not supported.}
}
}
\examples{
path = tempfile()
writeARFF(iris, path = path)
d = readARFF(path)
}
