% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strtrim.R
\name{strtrim_ctl}
\alias{strtrim_ctl}
\alias{strtrim2_ctl}
\title{ANSI Control Sequence Aware Version of strtrim}
\usage{
strtrim_ctl(x, width, warn = getOption("fansi.warn"))

strtrim2_ctl(x, width, warn = getOption("fansi.warn"),
  tabs.as.spaces = getOption("fansi.tabs.as.spaces"),
  tab.stops = getOption("fansi.tab.stops"))
}
\arguments{
\item{x}{a character vector, or an object which can be coerced to a
    character vector by \code{\link{as.character}}.}

\item{width}{Positive integer values: recycled to the length of \code{x}.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}

\item{tabs.as.spaces}{FALSE (default) or TRUE, whether to convert tabs to
spaces.  This can only be set to TRUE if \code{strip.spaces} is FALSE.}

\item{tab.stops}{integer(1:n) indicating position of tab stops to use
when converting tabs to spaces.  If there are more tabs in a line than
defined tab stops the last tab stop is re-used.  For the purposes of
applying tab stops, each input line is considered a line and the character
count begins from the beginning of the input line.}
}
\description{
One difference with \link[base:strtrim]{base::strtrim} is that all C0 control characters such as
newlines, carriage returns, etc., are treated as zero width.
}
\details{
\code{strtrim2_ctl} adds the option of converting tabs to spaces before trimming.
This is the only difference between \code{strtrim_ctl} and \code{strtrim2_ctl}.
}
\note{
Non-ASCII strings are converted to and returned in UTF-8 encoding.
Width calculations will not work correctly with R < 3.2.0.
}
\examples{
strtrim_ctl("\\033[42mHello world\\033[m", 6)
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results.
\link{strwrap_ctl} is used internally by this function.
}
