% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substr2.R
\name{substr_ctl}
\alias{substr_ctl}
\alias{substr2_ctl}
\title{ANSI Control Sequence Aware Version of substr}
\usage{
substr_ctl(x, start, stop, warn = getOption("fansi.warn"),
  term.cap = getOption("fansi.term.cap"))

substr2_ctl(x, start, stop, type = "chars", round = "start",
  tabs.as.spaces = getOption("fansi.tabs.as.spaces"),
  tab.stops = getOption("fansi.tab.stops"), warn = getOption("fansi.warn"),
  term.cap = getOption("fansi.term.cap"))
}
\arguments{
\item{x}{a character vector or object that can be coerced to character.}

\item{start}{integer.  The first element to be replaced.}

\item{stop}{integer.  The last element to be replaced.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}

\item{term.cap}{character a vector of the capabilities of the terminal, can
be any combination "bright" (SGR codes 90-97, 100-107), "256" (SGR codes
starting with "38;5" or "48;5"), and "truecolor" (SGR codes starting with
"38;2" or "48;2"). Changing this parameter changes how \code{fansi} interprets
escape sequences, so you should ensure that it matches your terminal
capabilities. See \link{term_cap_test} for details.}

\item{type}{character(1L) partial matching \code{c("chars", "width")}.}

\item{round}{character(1L) partial matching
\code{c("start", "stop", "both", "neither")}, controls how to resolve
ambiguities when a \code{start} or \code{stop} value in "width" \code{type} mode falls
within a multi-byte character or a wide display character.  See details.}

\item{tabs.as.spaces}{FALSE (default) or TRUE, whether to convert tabs to
spaces.  This can only be set to TRUE if \code{strip.spaces} is FALSE.}

\item{tab.stops}{integer(1:n) indicating position of tab stops to use
when converting tabs to spaces.  If there are more tabs in a line than
defined tab stops the last tab stop is re-used.  For the purposes of
applying tab stops, each input line is considered a line and the character
count begins from the beginning of the input line.}
}
\description{
\code{substr_ctl} is a drop-in replacement for \code{substr}.  Performance is
slightly slower than \code{substr}.
}
\details{
\code{substr2_ctl} adds the ability to retrieve substrings based on display width,
and byte width in addition to the normal character width.  \code{substr2_ctl} also
provides the option to convert tabs to spaces with \link{tabs_as_spaces} prior to
taking substrings.
Because exact substrings on anything other than character width cannot be
guaranteed (e.g.  because of multi-byte encodings, or double display-width
characters) \code{substr2_ctl} must make assumptions on how to resolve provided
\code{start}/\code{stop} values that are infeasible and does so via the \code{round}
parameter.

If we use "start" as the \code{round} value, then any time the \code{start}
value corresponds to the middle of a multi-byte or a wide character, then
that character is included in the substring, while any similar partially
included character via the \code{stop} is left out.  The converse is true if we
use "stop" as the \code{round} value.  "neither" would cause all partial
characters to be dropped irrespective whether they correspond to \code{start} or
\code{stop}, and "both" could cause all of them to be included.
}
\note{
Non-ASCII strings are converted to and returned in UTF-8 encoding.
}
\examples{
substr_ctl("\\033[42mhello\\033[m world", 1, 9)
substr_ctl("\\033[42mhello\\033[m world", 3, 9)

## Width 2 and 3 are in the middle of an ideogram as
## start and stop positions respectively, so we control
## what we get with `round`

cn.string <- paste0("\\033[42m", "\\u4E00\\u4E01\\u4E03", "\\033[m")

substr2_ctl(cn.string, 2, 3, type='width')
substr2_ctl(cn.string, 2, 3, type='width', round='both')
substr2_ctl(cn.string, 2, 3, type='width', round='start')
substr2_ctl(cn.string, 2, 3, type='width', round='stop')
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results.
}
