% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictS4Methods.R
\name{predict}
\alias{predict}
\alias{predict,familiarModel-method}
\alias{predict,familiarEnsemble-method}
\alias{predict,familiarNoveltyDetector-method}
\alias{predict,list-method}
\alias{predict,character-method}
\title{Model predictions for familiar models and model ensembles}
\usage{
predict(object, ...)

\S4method{predict}{familiarModel}(
  object,
  newdata,
  type = "default",
  time = NULL,
  dir_path = NULL,
  ensemble_method = "median",
  stratification_threshold = NULL,
  stratification_method = NULL,
  percentiles = NULL,
  ...
)

\S4method{predict}{familiarEnsemble}(
  object,
  newdata,
  type = "default",
  time = NULL,
  dir_path = NULL,
  ensemble_method = "median",
  stratification_threshold = NULL,
  stratification_method = NULL,
  percentiles = NULL,
  ...
)

\S4method{predict}{familiarNoveltyDetector}(object, newdata, type = "novelty", ...)

\S4method{predict}{list}(
  object,
  newdata,
  type = "default",
  time = NULL,
  dir_path = NULL,
  ensemble_method = "median",
  stratification_threshold = NULL,
  stratification_method = NULL,
  percentiles = NULL,
  ...
)

\S4method{predict}{character}(
  object,
  newdata,
  type = "default",
  time = NULL,
  dir_path = NULL,
  ensemble_method = "median",
  stratification_threshold = NULL,
  stratification_method = NULL,
  percentiles = NULL,
  ...
)
}
\arguments{
\item{object}{A familiar model or ensemble of models that should be used for
prediction. This can also be a path to the ensemble model, one or more paths
to models, or a list of models.}

\item{...}{to be documented.}

\item{newdata}{Data to which the models are fitted. \code{familiar} performs checks
on the data to ensure that all features required for fitting the model are
present, and no additional levels are present in categorical features.
Unlike other \code{predict} methods, \code{newdata} cannot be missing in \code{familiar},
as training data are not stored with the models.}

\item{type}{Type of prediction made. The following values are directly
supported:
\itemize{
\item \code{default}: Default prediction, i.e. value estimates for \code{count} and
\code{continuous} outcomes, predicted class probabilities and class for
\code{binomial} and \code{multinomial} and the model response for \code{survival} outcomes.
\item \code{survival_probability}: Predicts survival probabilities at the time
specified by \code{time}. Only applicable to \code{survival} outcomes. Some models may
not allow for predicting survival probabilities based on their response.
\item \code{novelty}: Predicts novelty of each sample, which can be used for
out-of-distribution detection.
\item \code{risk_stratification}: Predicts the strata to which the data belongs. Only
for \code{survival} outcomes.
}

Other values for type are passed to the fitting method of the actual
underlying model. For example for generalised linear models (\code{glm}) \code{type}
can be \code{link}, \code{response} or \code{terms} as well. Some of these model-specific
prediction types may fail to return results if the model has been trimmed.}

\item{time}{Time at which the response (\code{default}) or survival probability
(\code{survival_probability}) should be predicted for \code{survival} outcomes. Some
models have a response that does not depend on \code{time}, e.g. \code{cox}, whereas
others do, e.g. \code{random_forest}.}

\item{dir_path}{Path to the folder containing the models. Ensemble objects are
stored with the models detached. In case the models were moved since
creation, \code{dir_path} can be used to specify the current folder.
Alternatively the \code{update_model_dir_path} method can be used to update the
path.}

\item{ensemble_method}{Method for ensembling predictions from models for the
same sample. Available methods are:
\itemize{
\item \code{median} (default): Use the median of the predicted values as the ensemble
value for a sample.
\item \code{mean}: Use the mean of the predicted values as the ensemble value for a
sample.
}}

\item{stratification_threshold}{Threshold value(s) used for stratifying
instances into risk groups. If this parameter is specified,
\code{stratification_method} and any threshold values that come with the model
are ignored, and \code{stratification_threshold} is used instead.}

\item{stratification_method}{Selects the stratification method from which the
threshold values should be selected. If the model or ensemble of models does
not contain thresholds for the indicated method, an error is returned. In
addition this argument is ignored if a \code{stratification_threshold} is set.}

\item{percentiles}{Currently unused.}
}
\value{
A \code{data.table} with predicted values.
}
\description{
Fits the model or ensemble of models to the data and shows the
result.
}
\details{
This method is used to predict values for instances specified by the
\code{newdata} using the model or ensemble of models specified by the \code{object}
argument.
}
