% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_rate_parity.R
\name{pred_rate_parity}
\alias{pred_rate_parity}
\title{Predictive Rate Parity}
\usage{
pred_rate_parity(data, outcome, group, probs = NULL, preds = NULL,
  outcome_levels = NULL, cutoff = 0.5, base = NULL)
}
\arguments{
\item{data}{The dataframe that contains the necessary columns.}

\item{outcome}{The column name of the actual outcomes.}

\item{group}{Sensitive group to examine.}

\item{probs}{The column name or vector of the predicted probabilities (numeric between 0 - 1). If not defined, argument preds needs to be defined.}

\item{preds}{The column name or vector of the predicted outcome (categorical outcome). If not defined, argument probs needs to be defined.}

\item{outcome_levels}{The desired levels of the predicted outcome (categorical outcome). If not defined, all unique values of outcome are used.}

\item{cutoff}{Cutoff to generate predicted outcomes from predicted probabilities. Default set to 0.5.}

\item{base}{Base level for sensitive group comparison}
}
\value{
\item{Metric}{Raw precision metrics for all groups and metrics standardized for the base group (predictive rate parity metric). Lower values compared to the reference group mean lower precisions in the selected subgroups}
\item{Metric_plot}{Bar plot of Predictive Rate Parity metric}
\item{Probability_plot}{Density plot of predicted probabilities per subgroup. Only plotted if probabilities are defined}
}
\description{
This function computes the Predictive Rate Parity metric
}
\details{
This function computes the Predictive Rate Parity metric (also known as Sufficiency) as described by
Zafar et al., 2017. Predictive rate parity is calculated by the division of true positives with all
observations predicted positives. This metrics equals to what is traditionally known as precision
or positive predictive value. In the returned named vector, the reference group will be assigned 1,
while all other groups will be assigned values according to whether their precisions are lower or
higher compared to the reference group. Lower precisions will be reflected in numbers lower than 1
in the returned named vector, thus numbers lower than 1 mean WORSE prediction for the subgroup.
}
\examples{
data(compas)
pred_rate_parity(data = compas, outcome = 'Two_yr_Recidivism', group = 'ethnicity',
probs = 'probability', preds = NULL, outcome_levels = c('no', 'yes'),
cutoff = 0.4, base = 'Caucasian')
pred_rate_parity(data = compas, outcome = 'Two_yr_Recidivism', group = 'ethnicity',
probs = NULL, preds = 'predicted', outcome_levels = c('no', 'yes'),
cutoff = 0.5, base = 'Hispanic')

}
