% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.fairness_object}
\alias{print.fairness_object}
\title{Print Fairness Object}
\usage{
\method{print}{fairness_object}(x, ..., colorize = TRUE)
}
\arguments{
\item{x}{\code{fairness_object} object}

\item{...}{other parameters}

\item{colorize}{logical, whether information about metrics should be in color or not}
}
\description{
Print Fairness Object
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           max.depth = 3,
                           num.trees = 100,
                           seed = 1,
                           num.threads = 1)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)

explainer_rf <- DALEX::explain(rf_model,
                               data = german[,-1],
                               y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

print(fobject)


}
