% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_chosen_metric.R
\name{plot.chosen_metric}
\alias{plot.chosen_metric}
\title{Plot chosen metric}
\usage{
\method{plot}{chosen_metric}(x, ...)
}
\arguments{
\item{x}{object of class \code{chosen_metric}}

\item{...}{other objects of class \code{chosen_metric}}
}
\value{
\code{ggplot2} object
}
\description{
Choose metric from parity loss metrics and plot it for every model.
 The one with the least parity loss is more fair in terms of this particular metric.
}
\examples{
data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm,
                          protected = german$Sex,
                          privileged = "male")


cm <- choose_metric(fobject, "TPR")
plot(cm)

\donttest{
rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)


explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_rf, fobject)

cm <- choose_metric(fobject, "TPR")
plot(cm)

}
}
