% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{predprecision}
\alias{predprecision}
\title{Predicts precision matrix and its determinant (Woodbury variant)}
\usage{
predprecision(x, ahead = 1, each = 1)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{ahead}{Vector of timepoints, indicating how many steps
to predict ahead.}

\item{each}{Single integer (or coercible to such) indicating how
often should be drawn from the posterior predictive distribution
for each draw that has been stored during MCMC sampling.}
}
\value{
List containing two elements:
\itemize{
\item{precision}{Array containing the draws of the predicted
precision matrix.}
\item{precisionlogdet}{Matrix containing the draws of the determinant
of the predicted precision matrix.}
}
}
\description{
\code{predprecision} simulates from the posterior predictive distribution
of the model-implied precision matrix and its determinant
using the Woodbury matrix identity and the matrix determinant lemma
}
\note{
Currently crudely implemented as a triple loop in pure R,
may be slow.
}
\seealso{
Usually used for evaluating the predictive likelihood when many
series but few factors are used, see
\code{\link{predloglik}}.

Other predictors: \code{\link{predcond}},
  \code{\link{predcor}}, \code{\link{predcov}},
  \code{\link{predh}}, \code{\link{predloglikWB}},
  \code{\link{predloglik}}
}

