% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconciliation.R
\name{min_trace}
\alias{min_trace}
\title{Minimum trace forecast reconciliation}
\usage{
min_trace(
  models,
  method = c("wls_var", "ols", "wls_struct", "mint_cov", "mint_shrink"),
  sparse = NULL
)
}
\arguments{
\item{models}{A column of models in a mable.}

\item{method}{The reconciliation method to use.}

\item{sparse}{If TRUE, the reconciliation will be computed using sparse
matrix algebra? By default, sparse matrices will be used if the MatrixM
package is installed.}
}
\description{
Reconciles a hierarchy using the minimum trace combination method. The
response variable of the hierarchy must be aggregated using sums. The
forecasted time points must match for all series in the hierarchy (caution:
this is not yet tested for beyond the series length).
}
\references{
Wickramasuriya, S. L., Athanasopoulos, G., & Hyndman, R. J. (2019). Optimal forecast reconciliation for hierarchical and grouped time series through trace minimization. Journal of the American Statistical Association, 1-45. https://doi.org/10.1080/01621459.2018.1448825
}
\seealso{
\code{\link[=reconcile]{reconcile()}}, \code{\link[=aggregate_key]{aggregate_key()}}
}
