% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta.R
\name{tidy.fable_theta}
\alias{tidy.fable_theta}
\title{Tidy a fable model}
\usage{
\method{tidy}{fable_theta}(x, ...)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}

\item{...}{Additional arguments to tidying method.}
}
\value{
The model's coefficients in a \code{tibble}.
}
\description{
Returns the coefficients from the model in a \code{tibble} format.
}
\examples{
USAccDeaths \%>\%
  as_tsibble() \%>\%
  model(arima = ARIMA(log(value) ~ pdq(0, 1, 1) + PDQ(0, 1, 1))) \%>\%
  tidy()
}
