% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{refit.model_mean}
\alias{refit.model_mean}
\title{Refit a MEAN model}
\usage{
\method{refit}{model_mean}(object, new_data, specials = NULL, reestimate = FALSE, ...)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{new_data}{A \code{tsibble} containing future information used to forecast.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{reestimate}{If \code{TRUE}, the mean for the fitted model will be re-estimated
to suit the new data.}

\item{...}{Additional arguments for forecast model methods.}
}
\description{
Applies a fitted average method model to a new dataset.
}
\examples{
lung_deaths_male <- as_tsibble(mdeaths)
lung_deaths_female <- as_tsibble(fdeaths)

fit <- lung_deaths_male \%>\%
  model(MEAN(value))

report(fit)

fit \%>\%
  refit(lung_deaths_female) \%>\%
  report()
}
