% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-viz.R
\name{bookdown_open}
\alias{bookdown_open}
\title{Open a a web-based bookdown folder in a browser}
\usage{
bookdown_open(bookdown_path)
}
\arguments{
\item{bookdown_path}{A character string identifying the folder path
containing the files to open the bookdown site.}
}
\value{
Nothing to be returned. The function opens a web page.
}
\description{
Opens a previously generated HTML bookdown site from files in the specified
folder. This is a shortcut function to access 'index.html' in the specified
folder.
}
\examples{
{

bookdown_path = tempdir()
bookdown_template(bookdown_path, overwrite = TRUE)
bookdown_render(bookdown_path, overwrite = TRUE)
bookdown_open(bookdown_path)

}

}
\seealso{
\code{\link[=bookdown_template]{bookdown_template()}},\code{\link[=bookdown_open]{bookdown_open()}}
}
