% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.fSRM}
\alias{plot.fSRM}
\title{Plot an fSRM-object, two types}
\usage{
\method{plot}{fSRM}(x, ..., means = FALSE, bw = FALSE, onlyStable = FALSE)
}
\arguments{
\item{x}{A fSRM object.}

\item{...}{Other parameters (currently not used)}

\item{means}{If FALSE, the relative variances are plotted. If TRUE, the mean structure is plotted.}

\item{bw}{Black/white plotting?}

\item{onlyStable}{In case of variance plots: Should only the partitioning of the \emph{stable} variance (without error) be plotted?}
}
\description{
This function provides two types of plots:
1) Plot the relative variances of an fSRM-object (default)
2) Plot the mean decomposition for each dyad (set \code{means=TRUE})
}
\examples{
data(two.indicators)
# 4 persons, 1 indicator
f4.1 <- fSRM(dep1 ~ actor.id*partner.id | family.id, two.indicators)
f4.1
plot(f4.1)
plot(f4.1, bw=TRUE)

# 4 persons, 2 indicators
f4.2 <- fSRM(dep1/dep2 ~ actor.id*partner.id | family.id, two.indicators)
f4.2
plot(f4.2)
plot(f4.2, bw=TRUE)
}

