% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rob_scale.R
\name{rob_scale}
\alias{rob_scale}
\title{Stabilize the center and scale of a timeseries robustly}
\usage{
rob_scale(x, center = TRUE, scale = TRUE, lmrob_method = "MM", rescale = TRUE)
}
\arguments{
\item{x}{The timeseries to stabilize.}

\item{center, scale}{Center and scale? Default: \code{TRUE} for both. If
scaling but not centering, the data must already be centered; otherwise,
the results will be invalid. Can also be the number of DCT bases to use for
robust stabilization of center/scale; \code{TRUE} will use \code{4}.}

\item{lmrob_method}{The \code{lmrob_method} argument to \code{robustbase::lmrob}.}

\item{rescale}{After stabilizing \code{x}, re-center and re-scale
to the original mean and variance? Default: \code{TRUE}.}
}
\value{
the timeseries with its center and scale stabilized
}
\description{
Stabilize the center and scale of a timeseries using robust regression of
DCT bases on the first and second moments.
}
