% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_and_models.R
\docType{data}
\name{dax}
\alias{dax}
\title{Deutscher Aktienindex (DAX) index data}
\format{
A \code{data.frame} with 9012 rows and the following 7 columns:
\itemize{
\item \code{Date}: The date.
\item \code{Open}: Opening price.
\item \code{High}: Highest price.
\item \code{Low}: Lowest price.
\item \code{Close}: Close price adjusted for splits.
\item \code{Adj.Close}: Close price adjusted for dividends and splits.
\item \code{Volume}: Trade volume.
}
}
\usage{
dax
}
\description{
Deutscher Aktienindex (DAX) index data from 1988 to 2022 from Yahoo Finance.
}
\details{
The data was obtained via:
\preformatted{
dax <- download_data(
  symbol = "^GDAXI",   # DAX identifier on Yahoo Finance
  from = "1988-01-01", # first observation
  to = "2022-12-31"    # last observation
)
}
The data is also available as \code{.csv} file via:
\preformatted{
system.file("extdata", "dax.csv", package = "fHMM")
}
}
\keyword{data}
