% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_hmm.R
\name{fit_hmm}
\alias{fit_hmm}
\title{Fit (hierarchical) hidden Markov models to financial data}
\usage{
fit_hmm(controls, events, sim_par)
}
\arguments{
\item{controls}{A list of controls (optional).}

\item{events}{A list of (historical, financial) events (optional).}

\item{sim_par}{A list of model parameters for simulation in \code{thetaList} format, default \code{NULL} (optional).}
}
\value{
No return value. Estimation results are saved in "\code{controls[["path"]]}/models/\code{controls[["id"]]}".
}
\description{
Performs data processing, fitting, state decoding and visualization.
}
\details{
Specify a model by setting parameters of the named list \code{controls} and passing it to \code{fit_hmm}.
See the vignettes on how to specify \code{controls}.
}
\examples{
### fitting a 2-state HMM with state-dependent t-distributions to simulated data
controls = list(
  path    = tempdir(),
  id      = "test",
  model   = "hmm",
  states  = 2,
  sdds    = "t",
  horizon = 200,
  fit     = list("runs" = 10, "seed" = 1)
)
fit_hmm(controls)
}
