
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Library General Public License for more details.
#
# You should have received A copy of the GNU Library General
# Public License along with this library; if not, write to the
# Free Foundation, Inc., 59 Temple Place, Suite 330, Boston,
# MA  02111-1307  USA


################################################################################
# FUNCTION:                 DESCRIPTION:
#  as.matrix.ts              Converts univariate ts to 1-column matrix
#  as.matrix.mts             Converts multivariate ts to matrix
################################################################################


## as.matrix.ts <-
## function(x, ...)
## {
##     # A function implemented by Diethelm Wuertz

##     # Description:
##     #   Coerces a "ts" object into a matrix

##     # FUNCTION:

##     # Transform:
##     ans = as.matrix.default(unclass(x))
##     attr(ans, "tsp")<-NULL
##     rownames(ans)<-NULL
##     colnames(ans)<-NULL

##     # Return Value:
##     ans
## }


## # ------------------------------------------------------------------------------


## as.matrix.mts <-
## function(x, ...)
## {
##     # A function implemented by Diethelm Wuertz

##     # Description:
##     #   Coerces a multivariate "ts" object into a matrix

##     # FUNCTION:

##     # Transform:
##     ans = as.matrix.default(unclass(x))
##     attr(ans, "tsp")<-NULL
##     rownames(ans)<-NULL
##     colnames(ans)<-NULL

##     # Return Value:
##     ans
## }


################################################################################

