% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_plot.R
\name{distribution_plot}
\alias{distribution_plot}
\title{distribution_plot}
\usage{
distribution_plot(
  data,
  x,
  facet_x = NULL,
  nbins = 20,
  use_theme = theme_ez,
  size = 11,
  env = parent.frame()
)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{nbins}{Number of bins for histogram. Default is 20.}

\item{use_theme}{ggplot theme function}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{env}{environment for evaluating expressions.}
}
\description{
distribution_plot
}
\examples{
n = 100
df = data.frame(residuals = rnorm(n),
                group1 = sample(c("a", "b"), n, replace = TRUE))
distribution_plot(df, "residuals")
distribution_plot(df, "residuals", "group1")
}
