% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_ice.R
\name{extr_ice_assay_names}
\alias{extr_ice_assay_names}
\title{Extract Assay Names from the ICE Database}
\usage{
extr_ice_assay_names(regex = NULL, verbose = TRUE)
}
\arguments{
\item{regex}{A character string containing the regular expression to search for,
or \code{NULL} to retrieve all assay names.}

\item{verbose}{A logical value indicating whether to print detailed messages.
Default is TRUE.}
}
\value{
A character vector of matching assay names.
}
\description{
This function allows users to search for assay names in the ICE database
using a regular expression. If no search pattern is provided (\code{regex = NULL}),
it returns all available assay names.
}
\examples{
\donttest{
extr_ice_assay_names("OPERA")
extr_ice_assay_names(NULL)
extr_ice_assay_names("Vivo")
}
}
