% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_iris.R
\name{extr_iris}
\alias{extr_iris}
\title{Extract Data from EPA IRIS Database}
\usage{
extr_iris(casrn = NULL, verbose = TRUE)
}
\arguments{
\item{casrn}{A vector CASRN for the search.}

\item{verbose}{A logical value indicating whether to print detailed messages.
Default is TRUE.}
}
\value{
A data frame containing the extracted data.
}
\description{
The \code{extr_iris} function sends a request to the EPA IRIS database to search
for information based on a specified keywords and cancer types. It retrieves
and parses the HTML content from the response.
}
\examples{
\donttest{
extr_iris(casrn = c("1332-21-4", "50-00-0"))
}
}
\seealso{
\href{https://cfpub.epa.gov/ncea/iris/search/}{EPA IRIS database}
}
