% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_tox.R
\name{extr_ice}
\alias{extr_ice}
\title{Extract Data from NTP ICE Database}
\usage{
extr_ice(casrn, assays = NULL, verify_ssl = FALSE, ...)
}
\arguments{
\item{casrn}{A character vector specifying the CASRNs for the search.}

\item{assays}{A character vector specifying the assays to include in the search. Default is NULL, meaning all assays are included.}

\item{verify_ssl}{Boolean to control of SSL should be verified or not.}

\item{...}{Any other arguments to be supplied to \code{req_option} and thus to \code{libcurl}.}
}
\value{
A data frame containing the extracted data from the ICE API.
}
\description{
The \code{extr_ice} function sends a POST request to the ICE API to search for information based on specified chemical IDs and assays.
}
\examples{
\donttest{
extr_ice(c("50-00-0"))
}
}
\seealso{
\href{https://ice.ntp.niehs.nih.gov/}{NTP ICE database}
}
