% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location-scale-t-distribution.R
\name{LocationScaleT}
\alias{LocationScaleT}
\alias{dlst}
\alias{plst}
\alias{qlst}
\alias{rlst}
\title{Location-scale version of the t-distribution}
\usage{
dlst(x, df, mu = 0, sigma = 1, log = FALSE)

plst(q, df, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qlst(p, df, mu = 0, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rlst(n, df, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{df}{degrees of freedom (> 0, maybe non-integer). \code{df = Inf} is allowed.}

\item{mu}{vector of locations}

\item{sigma}{vector of positive valued scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function, distribution function and random generation
for location-scale version of the t-distribution. Location-scale version
of the t-distribution besides degrees of freedom \eqn{\nu}, is parametrized
using additional parameters \eqn{\mu} for location and \eqn{\sigma} for
scale (\eqn{\mu = 0} and \eqn{\sigma = 1} for standard t-distribution).
}
\examples{

x <- rlst(1e5, 1000, 5, 13)
hist(x, 100, freq = FALSE)
curve(dlst(x, 1000, 5, 13), -60, 60, col = "red", add = TRUE)
hist(plst(x, 1000, 5, 13))
plot(ecdf(x))
curve(plst(x, 1000, 5, 13), -60, 60, col = "red", lwd = 2, add = TRUE)

}
\seealso{
\code{\link[stats]{TDist}}
}
\concept{
Univariate

Continuous
}
\keyword{distribution}
