% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/half-normal-distribution.R
\name{HalfNormal}
\alias{HalfNormal}
\alias{dhnorm}
\alias{phnorm}
\alias{qhnorm}
\alias{rhnorm}
\title{Half-normal distribution}
\usage{
dhnorm(x, sigma = 1, log = FALSE)

phnorm(q, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qhnorm(p, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rhnorm(n, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{sigma}{positive valued scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the half-normal distribution.
}
\details{
If \eqn{X} follows normal distribution centered at 0 and parametrized
by scale \eqn{\sigma}, then \eqn{|X|} follows half-normal distribution
parametrized by scale \eqn{\sigma}. Half-t distribution with \eqn{\nu=\infty}
degrees of freedom converges to half-normal distribution.
}
\examples{

x <- rhnorm(1e5, 2)
hist(x, 100, freq = FALSE)
curve(dhnorm(x, 2), 0, 8, col = "red", add = TRUE)
hist(phnorm(x, 2))
plot(ecdf(x))
curve(phnorm(x, 2), 0, 8, col = "red", lwd = 2, add = TRUE)

}
\references{
Gelman, A. (2006). Prior distributions for variance parameters in hierarchical
models (comment on article by Browne and Draper).
Bayesian analysis, 1(3), 515-534.

Jacob, E. and Jayakumar, K. (2012).
On Half-Cauchy Distribution and Process.
International Journal of Statistika and Mathematika, 3(2), 77-81.
}
\seealso{
\code{\link{HalfT}}
}
\concept{
Univariate

Continuous
}
\keyword{distribution}
