% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extraDistr-package.R
\docType{package}
\name{extraDistr-package}
\alias{extraDistr-package}
\title{extraDistr: Additional Univariate and Multivariate Distributions}
\description{
Density, distribution function, quantile function and random generation for a number of univariate and multivariate distributions. This package implements the following distributions: Bernoulli, beta-binomial, beta-negative binomial, beta prime, Bhattacharjee, Birnbaum-Saunders, bivariate normal, bivariate Poisson, categorical, Dirichlet, Dirichlet-multinomial, discrete gamma, discrete Laplace, discrete normal, discrete uniform, discrete Weibull, Frechet, gamma-Poisson, generalized extreme value, Gompertz, generalized Pareto, Gumbel, half-Cauchy, half-normal, half-t, Huber density, inverse chi-squared, inverse-gamma, Kumaraswamy, Laplace, location-scale t, logarithmic, Lomax, multivariate hypergeometric, multinomial, negative hypergeometric, non-standard beta, normal mixture, Poisson mixture, Pareto, power, reparametrized beta, Rayleigh, shifted Gompertz, Skellam, slash, triangular, truncated binomial, truncated normal, truncated Poisson, Tukey lambda, Wald, zero-inflated binomial, zero-inflated negative binomial, zero-inflated Poisson.

Density, distribution function, quantile function and random
generation for a number of univariate and multivariate distributions.
}
\details{
This package follows naming convention that is consistent with base R,
where density (or probability mass) functions, distribution functions,
quantile functions and random generation functions names are followed by
\code{d}*, \code{p}*, \code{q}*, and \code{r}* prefixes.

Behaviour of the functions is consistent with base R, where for
not valid parameters values \code{NaN}'s are returned, while
for values beyond function support \code{0}'s are returned
(e.g. for non-integers in discrete distributions, or for
negative values in functions with non-negative support).

All the functions vectorized and coded in C++ using \pkg{Rcpp}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/twolodzko/extraDistr}
  \item Report bugs at \url{https://github.com/twolodzko/extraDistr/issues}
}


Useful links:
\itemize{
  \item \url{https://github.com/twolodzko/extraDistr}
  \item Report bugs at \url{https://github.com/twolodzko/extraDistr/issues}
}

}
\author{
\strong{Maintainer}: Tymoteusz Wolodzko \email{twolodzko+extradistr@gmail.com}

}
\keyword{internal}
