rlplot.gui <- function( base.txt) {

conf.value <- tclVar("0.05")
ci <- tclVar(0)
rlevel.value <- tclVar("")

# Refresh fcn 
refresh <- function() {
	tkdelete( fit.listbox, 0.0, "end")
	if( !is.nothing) {
                data.select <- as.numeric( tkcurselection( data.listbox))+1
                dd <- get( full.list[ data.select])
                } else stop("rlplot.gui: Must load a data object!")
	models.fit <- names( dd$models)
	for( i in 1:length( models.fit))
		tkinsert( fit.listbox, "end", paste( models.fit[i]))
	invisible()
} # end of refresh fcn.

submit <- function() {
	if( !is.nothing) {
                data.select <- as.numeric( tkcurselection( data.listbox))+1
                dd.cmd <- paste( "dd <- get( \"", full.list[ data.select], "\")", sep="")
                } else stop("rlplot.gui: Must load a data object!")
	eval( parse( text=dd.cmd))
	write( dd.cmd, file="extRemes.log", append=TRUE)

	fit.select <- as.numeric( tkcurselection( fit.listbox))+1

	# z <- dd$models[[ fit.select]]
	# z.cmd <- paste( "z <- ", full.list[ data.select], "$models[[", fit.select, "]]", sep="")
	z.cmd <- paste( "z <- dd[[\"models\"]][[ ", fit.select, "]]", sep="")
	eval( parse( text=z.cmd))
	write( z.cmd, file="extRemes.log", append=TRUE)
	ci.val <- as.numeric(tclvalue(conf.value))
	# rlplot(a=z$mle, u=z$threshold, la=z$rate, n=z$n, npy=z$npy, mat=z$cov, dat=z$data, xdat=z$xdata,
	# 		klaas=class(z), ci=ci.val, add.ci=ifelse( tclvalue(ci)==1, TRUE,FALSE))
	# rlplotCMD <- paste( "rlplot( a=z[[\"mle\"]], u=z[[\"threshold\"]], la=z[[\"rate\"]], n=z[[\"n\"]], ",
	# 	"mat=z[[\"cov\"]], dat=z[[\"data\"]], xdat=z[[\"xdata\"]], klaas=class( z), ",
	# 	"ci=", ci.val, ", add.ci=", ifelse( tclvalue(ci)==1, TRUE,FALSE), ")", sep="")
	save.rlvs <- tclvalue( rlevel.value)
	if( save.rlvs == "") rlplotCMD <- paste( "rlplot( z=z, ci=", ci.val, ", add.ci=", ifelse( tclvalue(ci)==1, TRUE,FALSE), ")", sep="")
	else rlplotCMD <- paste( "rlvals <- rlplot( z=z, ci=", ci.val, ", add.ci=", ifelse( tclvalue(ci)==1, TRUE,FALSE), ")", sep="")
	eval( parse( text=rlplotCMD))
	write( rlplotCMD, file="extRemes.log", append=TRUE)

	if( save.rlvs != "") {
		CMD <- paste( "assign( \"", save.rlvs, "\", rlvals, pos=\".GlobalEnv\")", sep="")
		eval( parse( text=CMD))
		write( CMD, file="extRemes.log", append=TRUE)
		}
	tkdestroy( base)
	invisible()
} # end of submit fcn.

rlhelp <- function() {
	# tkconfigure(base.txt,state="normal")
	msg1 <- paste("", "Plots the return levels for several return periods.", "",
			"If desired, confidence bounds may be added using the delta method.", " ",
			sep="\n")
	cat( msg1)
	# tkinsert(base.txt,"end",msg1)
	# tkconfigure(base.txt,state="disabled")
	# help( return.level)
	} # end of rlhelp fcn

endprog <- function() {
	tkdestroy( base)
	}
# Function to plot diagnostic plots for various fits.

#####################
# Frame/button setup.
#####################

base <- tktoplevel()
tkwm.title( base, "Return Level Plot for Fitted Object")

top.frm <- tkframe( base, borderwidth=2, relief="groove")
mid.frm <- tkframe( base, borderwidth=2, relief="groove")
rlvl.frm <- tkframe( base, borderwidth=2, relief="groove")
bot.frm <- tkframe( base, borderwidth=2, relief="groove")

data.listbox <- tklistbox( top.frm,
                        yscrollcommand=function(...) tkset( data.scroll, ...),
                        selectmode="single",
                        width=20,
                        height=5,
                        exportselection=0)

data.scroll <- tkscrollbar( top.frm, orient="vert",
                        command=function(...) tkyview( data.listbox, ...))

temp <- ls( all.names=TRUE, name=".GlobalEnv")
full.list <- character(0)
is.nothing <- TRUE
for( i in 1:length( temp)) {
        if( is.null( class( get( temp[i])))) next
        if( (class( get( temp[i]))[1] == "extRemesDataObject")) {
                tkinsert( data.listbox, "end", paste( temp[i]))
                full.list <- c( full.list, temp[i])
                is.nothing <- FALSE
                }
        } # end of for i loop

tkpack( tklabel( top.frm, text="Data Object:  ", padx=4), side="left")
tkpack( data.listbox, data.scroll,  side="left", fill="y")

# Place bindings on data listbox to update fit listbox.
tkbind( data.listbox, "<Button-1>", "")
tkbind( data.listbox, "<ButtonRelease-1>", refresh)

# Middle frame for choosing confidence level and which fit to plot.
# conf.frm <- tkframe( mid.frm, borderwidth=2, relief="groove")
# conf.entry <- tkentry( conf.frm, textvariable=conf.value, width=5)
# tkpack( tklabel( conf.frm, text="Confidence Level", padx=4), conf.entry, side="left")

fit.frm <- tkframe( mid.frm, borderwidth=2, relief="flat")
fit.listbox <- tklistbox( fit.frm,
			yscrollcommand=function(...) tkset( fit.scroll, ...),
			selectmode="single",
			width=20,
			height=5,
			exportselection=0)

fit.scroll <- tkscrollbar( fit.frm, orient="vert",
			command=function(...) tkyview( fit.listbox, ...))
tkinsert( fit.listbox, "end", "")

tkpack( tklabel( fit.frm, text="Select a fit: ", padx=4), side="left")
tkpack( fit.listbox, fit.scroll, side="left", fill="y")
tkpack(fit.frm, side="top")

# Return Level confidence interval frame.
conf.frm <- tkframe( rlvl.frm, borderwidth=2, relief="groove")
conf.entry <- tkentry( conf.frm, textvariable=conf.value, width=5)
tkpack( tklabel( conf.frm, text="Confidence Level", padx=4), conf.entry, side="left")

rlvl.chk <- tkcheckbutton(rlvl.frm,text="Add confidence bounds",variable=ci)
tkpack( conf.frm, rlvl.chk, side="top")
rlvl.entry <- tkentry( rlvl.frm, textvariable=rlevel.value, width=10)
tkpack( tklabel( rlvl.frm, text="Save Return Levels As (optional)",padx=4),rlvl.entry,side="left")

# Bottom frame for execution and cancellation.

ok.but <- tkbutton( bot.frm, text="OK", command=submit)
cancel.but <- tkbutton( bot.frm, text="Cancel", command=endprog)
help.but <- tkbutton( bot.frm, text="Help", command=rlhelp)

tkpack( ok.but, cancel.but, side="left")
tkpack( help.but, side="right")

# place bindings on buttons.
tkbind( ok.but, "<Return>", submit)
tkbind( cancel.but, "<Return>", endprog)
tkbind( help.but, "<Return>", rlhelp)

tkpack( top.frm, mid.frm, rlvl.frm, bot.frm, side="top", fill="x")
invisible()


} # end of fcn
