% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_tabularTestSummary.R
\name{tabularTestSummary}
\alias{tabularTestSummary}
\title{Summarize the result of a multiple comparison statistical test in a table}
\usage{
tabularTestSummary(ph, columns = c("pvalue"))
}
\arguments{
\item{ph}{The input testMultiple from which the table is generated}

\item{columns}{A vector indicating the metrics that will be shown in the table}
}
\value{
an extabular object
}
\description{
This function builds a table from a testMultiple object, either control or
pairwise. The htpotheses are added and compared in the table showing the
methods and a range of different metrics than can be added to the table.
Also the table shows information about rejected hypotheses.
}
\examples{
# First we create an experiment from the wekaExperiment problem and prepare
# it to apply the test:
experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
experiment <- expReduce(experiment, "fold", mean)
experiment <- expInstantiate(experiment, removeUnary=TRUE)

# Then we perform a a testMultiplePairwise test procedure
test <- testMultipleControl(experiment, "accuracy", "min")

# Different tables can be obtained by using a range of metrics
tabularTestSummary(test, c("pvalue"))

tabularTestSummary(test, c("rank", "pvalue", "wtl"))
}

