% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_tabularTestPairwise.R
\name{tabularTestPairwise}
\alias{tabularTestPairwise}
\title{Display pairwise information about a multiple test between the methods}
\usage{
tabularTestPairwise(ph, value = "pvalue", charForNAs = "-")
}
\arguments{
\item{ph}{The input testMultiplePairwise object}

\item{value}{Indicates the metric to be displayed ("pvalue", "wtl")}

\item{charForNAs}{Indicates the character included when there is not
comparison available}
}
\value{
An extabular object
}
\description{
This function obtain a pairwise table comparing the methods among themselves
for the specified metrics. It takes an testMultiplePairwise object as an
input.
}
\examples{
# First we create an experiment from the wekaExperiment problem and prepare
# it to apply the test:
experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
experiment <- expReduce(experiment, "fold", mean)
experiment <- expInstantiate(experiment, removeUnary=TRUE)

# Then we perform a a testMultiplePairwise test procedure
test <- testMultiplePairwise(experiment, "accuracy", "max")

# Different tables can be obtained by using a range of metrics
tabularTestPairwise(test, "pvalue")

tabularTestPairwise(test, "wtl")
}

