% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expReduce.R
\name{expReduce}
\alias{expReduce}
\title{Reduce a parameter by a function for each method, problem and remaining
parameter configuration interaction}
\usage{
expReduce(e, parameters = NULL, FUN = mean)
}
\arguments{
\item{e}{An input experiment object.}

\item{parameters}{The parameter or parameters to be reduced, if NULL or
default all parameters are considered.}

\item{FUN}{The function used to agregate the ouput values}
}
\value{
An experiment object.
}
\description{
This functions reduces a parameter by aggregating the outputs variables for each
value and for each configuration of method, problem and remaining parameters.
By default it computes the mean of the variables.
}
\examples{
# Create an experiment from the wekaExperiment
experiment <- expCreate(wekaExperiment, name="test-exp", parameter="fold")

# We would like to reduce the fold parameter by its mean value. This way
expReduce(experiment, "fold", mean)
}

