% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_proportions.R
\name{add_proportions}
\alias{add_proportions}
\title{Add Proportions}
\usage{
add_proportions(expstudy, ..., .base_grp_nms = character(0), .min_ungrpd = 0L)
}
\arguments{
\item{expstudy}{an \code{\link[=expstudy]{expstudy()}}}

\item{...}{other columns other than the \code{expstudy} metric variables (\code{actuals},
\code{expecteds}, and \code{exposures}) to generate proportions of}

\item{.base_grp_nms}{character vector of column names to use as the base of added proportions}

\item{.min_ungrpd}{minimum number of non-grouping columns required before using
\code{.base_grp_nms} as proportion base}
}
\value{
An \code{expstudy} with added proportions.
}
\description{
Add proportions of \code{expstudy} metric variables. Other variables can be
provided via the <\code{\link[rlang:dyn-dots]{dynamic-dots}}> argument. Proportions
will sum to 100\% per group if \code{.base_grp_nms} are provided. If
\code{.base_grp_nms} are omitted, proportions will sum to 100\% in total.
}
\examples{
  es <- expstudy(
    data = mortexp,
    actuals = ACTUAL_DEATHS,
    expecteds = EXPECTED_DEATHS,
    exposures =  EXPOSURE,
    variances = VARIANCE_DEATHS
  )

  # If no arguments are provided, proportions will be generated for expstudy
  # metric variables only. This mostly makes sense for already aggregated
  # expstudy objects, but can be used with unaggregated objects as well.
  es \%>\%
    aggregate(
      ATTAINED_AGE
    ) \%>\%
    add_proportions

  # For grouped proportions, use `.base_grp_nms` to identify which variable
  # to use as the base for proportions.
  es \%>\%
    aggregate(
      GENDER,
      SMOKING_STATUS
    ) \%>\%
    add_proportions(
      .base_grp_nms = 'GENDER'
    )

  # `.min_ungrpd` is useful only when generating multiple combinations of
  # results with compile_results(); this prevents proportions all equaling
  # 100\% when all grouping columns are used.

}
