% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_experimental.R
\name{experimental}
\alias{experimental}
\alias{.modify}
\alias{.modify_if}
\alias{.do_if}
\alias{.compute}
\alias{.calculate}
\alias{.calc}
\alias{.val_lab}
\alias{.var_lab}
\alias{.if_val}
\alias{.recode}
\alias{.fre}
\alias{.cro}
\alias{.cro_cpct}
\alias{.cro_rpct}
\alias{.cro_tpct}
\alias{.cro_mean}
\alias{.cro_sum}
\alias{.cro_median}
\alias{.cro_fun}
\alias{.cro_fun_df}
\alias{.set}
\title{Experimental functions for operations with default dataset}
\usage{
.modify(expr)

.modify_if(cond, expr)

.do_if(cond, expr)

.compute(expr)

.calculate(expr, use_labels = FALSE)

.calc(expr, use_labels = FALSE)

.val_lab(...)

.var_lab(...)

.if_val(x, ...)

.recode(x, ...)

.fre(...)

.cro(...)

.cro_cpct(...)

.cro_rpct(...)

.cro_tpct(...)

.cro_mean(...)

.cro_sum(...)

.cro_median(...)

.cro_fun(...)

.cro_fun_df(...)

.set(varnames, value = NA)
}
\arguments{
\item{expr}{set of expressions  in curly brackets which will be evaluated in
the context of default dataset}

\item{cond}{logical vector/expression}

\item{use_labels}{logical. Experimental feature. If it equals to \code{TRUE} 
then we will try to replace variable names with labels. So many base R
functions which show variable names will show labels.}

\item{...}{further arguments}

\item{x}{vector/data.frame - variable names in the scope of default dataset}

\item{varnames}{character vector. Deprecated.}

\item{value}{value/vector/matrix/data.frame. Value for newly created/existing
variables.}
}
\description{
Workflow for these functions is rather simple. You should set up default 
data.frame with \link{default_dataset} and then operate with it without any 
reference to your data.frame. There are two kinds of operations. The first kind
modify default dataset, the second kind will be evaluated in the context of
the default dataset but doesn't modify it. It is not recommended to use one
of these functions in the scope of another of these functions. By now their
performance is not so high, especially \code{.do_if}/\code{.modify_if} can be
very slow.
}
\details{
Functions which modify default dataset:
\itemize{
\item{\code{.modify}}{ Add and modify variables inside default data.frame. See
\link{modify}.}
\item{\code{.compute}}{ Shortcut for \code{.modify}. Name is inspired by
SPSS COMPUTE operator. See \link{modify}.}
\item{\code{.modify_if}}{ Add and modify variables inside subset of default
data.frame. See \link{modify_if}.}
\item{\code{.do_if}}{ Shortcut for \code{.modify_if}. Name is inspired by
SPSS DO IF operator. See \link{modify_if}.}
\item{\code{.where}}{ Leave subset of default data.frame which meet
condition. See \link{where}, \link[base]{subset}.}
\item{\code{.recode}}{ Change, rearrange or consolidate the values of an existing
variable inside default data.frame. See \link{recode}.}
\item{\code{.if_val}}{ Shortcut for \code{.recode}. See \link{recode}.} }
Other functions:
\itemize{
\item{\code{.var_lab}}{ Return variable label from default dataset. See
\link{var_lab}.}
\item{\code{.val_lab}}{ Return value labels from default dataset. See
\link{val_lab}.}
\item{\code{.fre }}{ Simple frequencies of variable in the default
data.frame.  See \link{fre}.}
\item{\code{.cro}/\code{.cro_cpct}/\code{.cro_rpct}/\code{.cro_tpct}}{ Simple
crosstabulations of variable in the default data.frame.  See \link{cro}.}
\item{\code{.cro_mean}/\code{.cro_sum}/\code{.cro_median}/\code{.cro_fun}/\code{.cro_fun_df}}{
Simple crosstabulations of variable in the default data.frame.  See 
\link{cro_fun}.}
\item{\code{.calculate}}{ Evaluate arbitrary expression in the context of
data.frame.  See \link{calculate}.}
}
}
\examples{
data(mtcars)

default_dataset(mtcars) # set mtcars as default dataset

# calculate new variables
.compute({
    mpg_by_am = ave(mpg, am, FUN = mean)
    hi_low_mpg = ifs(mpg<mean(mpg) ~ 0, TRUE ~ 1)    
})

# set labels
.apply_labels(
    mpg = "Miles/(US) gallon",
    cyl = "Number of cylinders",
    disp = "Displacement (cu.in.)",
    hp = "Gross horsepower",
    mpg_by_am = "Average mpg for transimission type",
    hi_low_mpg = "Miles per gallon",
    hi_low_mpg = num_lab("
                     0 Low
                     1 High
                     "),

    vs = "Engine",
    vs = num_lab(" 
                     0 V-engine
                     1 Straight engine
                 "),

    am = "Transmission",
    am = num_lab(" 
                     0 Automatic
                     1 Manual
                          ")
)
# calculate frequencies
.fre(hi_low_mpg)
.cro(cyl, hi_low_mpg)
.cro_mean(data.frame(mpg, disp, hp), vs)

# disable default dataset
default_dataset(NULL)

# Example of .recode

data(iris)

default_dataset(iris) # set iris as default dataset

.recode(Sepal.Length, lo \%thru\% median(Sepal.Length) ~ "small", other ~ "large")

.fre(Sepal.Length)

# example of .do_if
 
.do_if(Species == "setosa",{
     Petal.Length = NA
     Petal.Width = NA
})

.cro_mean(data.frame(Petal.Length, Petal.Width), Species)

# disable default dataset
default_dataset(NULL)
}
