context("f.labelled")

no_lab = rep(1:2,3)
vec_with_lab = no_lab
var_lab(vec_with_lab) = "Fruits"
val_lab(vec_with_lab) = c(Apple=1,Bananas=2)

expect_identical(f(unlab(vec_with_lab)),factor(no_lab))
expect_identical(f(unvr(vec_with_lab)),factor(no_lab,levels = 1:2,labels= c("Apple","Bananas")))
expect_identical(f(vec_with_lab),factor(no_lab,levels = 1:2,labels= c("Fruits|Apple","Fruits|Bananas")))
expect_identical(f(unvl(vec_with_lab)),factor(no_lab,levels = 1:2,labels= c("Fruits|1","Fruits|2")))

### Common usage ###

test_ds = data.frame(total = 1, s2b = sample(2:3,100,replace = TRUE))
test_ds = unlab(test_ds)
val_lab(test_ds$s2b) = c('18 - 26' = 2, '27 - 35' = 3)

# head(factor(test_ds$s2b))

expect_identical(levels(f(test_ds$s2b)), names(val_lab(test_ds$s2b)))


context("f.labelled - some values without labels")
no_lab = c(no_lab,5:6)
vec_with_lab = c(vec_with_lab,5:6)

expect_identical(f(unlab(vec_with_lab)),
                 factor(no_lab))
expect_identical(f(unvr(vec_with_lab)),
                 factor(no_lab,levels = c(1:2,5:6),labels= c("Apple","Bananas","5","6")))
expect_identical(f(vec_with_lab),
                 factor(no_lab,levels =  c(1:2,5:6),labels= c("Fruits|Apple","Fruits|Bananas","Fruits|5","Fruits|6")))
expect_identical(f(unvl(vec_with_lab)),
                factor(no_lab,levels =  c(1:2,5:6),labels= c("Fruits|1","Fruits|2","Fruits|5","Fruits|6")))


context( "f - errors and warnings")

a = 1
class(a) = "labelled"
attr(a, "labels") = c(a = 1, b = 1)
expect_error(f(a))
attr(a, "labels") = c(a = 1, a = 2)
expect_warning(f(a))
expect_identical(suppressWarnings(f(a)), factor(1, levels = 1:2, labels = c("a","a1")))
attr(a, "labels") = c(a = 1, a = 2, a = 3)
expect_identical(suppressWarnings(f(a)), factor(1, levels = 1:3, labels = c("a","a1","a2")))
