% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec_ops.R
\name{vectors}
\alias{\%a\%}
\alias{\%d\%}
\alias{\%e\%}
\alias{\%i\%}
\alias{\%r\%}
\alias{\%u\%}
\alias{vectors}
\title{Infix operations on vectors - append, diff, intersection, union, replication}
\usage{
e1 \%a\% e2

e1 \%u\% e2

e1 \%d\% e2

e1 \%i\% e2

e1 \%e\% e2

e1 \%r\% e2
}
\arguments{
\item{e1}{vector}

\item{e2}{vector (or function for \code{\%d\%}, \code{\%i\%})}
}
\value{
vector
}
\description{
\itemize{
\item{\code{\%a\%}}{ a(ppends) second argument to first argument.}
\item{\code{\%u\%}}{ u(ites) first and second arguments. Remove elements from
second argument that exist in first argument. }
\item{\code{\%d\%}}{ d(iffs) second argument from first argument. Second
argument could be a function which returns logical value. In this case
elements of first argument which give TRUE will be removed }
\item{\code{\%i\%}}{ i(ntersects) first argument and second argument. Second
argument could be a function which returns logical value. In this case
elements of first argument which give FALSE will be removed } 
\item{\code{\%e\%}}{ e(xclusive OR). Returns elements that contained only in one of arguments.}
\item{\code{\%r\%}}{ r(epeats) first argument second argument times}
} 
All these functions preserve names of vectors and doesn't remove duplicates.
For \code{\%d\%} and \code{\%i\%} one can use criteria functions. See \link{criteria}
 for details.
}
\examples{

1:4 \%a\% 5:6   # 1:6

1:4 \%a\% 4:5   # 1,2,3,4,4,5

1:4 \%u\% 4:5   # 1,2,3,4,5

1:6 \%d\% 5:6   # 1:4

# function as criterion
1:6 \%d\% gt(4) # 1:4

1:4 \%i\% 4:5   # 4

# function as criterion
letters \%i\% perl("[a-d]") # a,b,c,d

# function as criterion 
letters \%i\% (fixed("a") | fixed("z")) # a, z

1:4 \%e\% 4:5   # 1, 2, 3, 5

1:2 \%r\% 2     # 1, 2, 1, 2

}

