% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.R
\name{prop}
\alias{prop}
\alias{prop_col}
\alias{prop_row}
\title{Compute proportions from numeric vector/matrix/data.frame}
\usage{
prop(x)

prop_col(x)

prop_row(x)
}
\arguments{
\item{x}{numeric vector/matrix/data.frame}
}
\value{
the same structure as \code{x} but with proportions of original
  values from sum of original values.
}
\description{
\code{prop} returns proportion to sum of entire \code{x}. \code{prop_col} 
returns proportion to sum of each column of \code{x}. \code{prop_row} returns
proportion to sum of each row of \code{x}. Non-numeric columns in the
data.frame are ignored. NA's are also ignored.
}
\examples{
a = c(25, 25, NA)
prop(a)

# data.frame with non-numeric columns
fac = factor(c("a", "b", "c"))
char = c("a", "b", "c")
dat = as.POSIXct("2016-09-27") 
a = sheet(fac, a = c(25, 25, NA), b = c(100, NA, 50), char, dat)

prop(a)
prop_row(a)
prop_col(a)

# the same as result as with 'prop.table'
tbl = table(state.division, state.region)

prop(tbl)
prop_row(tbl)
prop_col(tbl)
}
