% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_category.R
\name{check_data}
\alias{check_data}
\title{Check experiment data}
\usage{
check_data(pheno, na.omit = FALSE)
}
\arguments{
\item{pheno}{Data.frame with the variables of each sample, one row one sample.}

\item{na.omit}{Check the effects of missing values too.}
}
\value{
A logical value indicating if everything is alright (TRUE) or not (FALSE).
}
\description{
In order to run a successful experiment a good design is needed even before measuring the data.
This functions checks several heuristics for a good experiment and warns if they are not found.
}
\examples{
rdata <- expand.grid(sex = c("M", "F"), class = c("lower", "median", "high"))
rdata2 <- rbind(rdata, rdata)
check_data(rdata2)
\donttest{
#Different warnings
check_data(rdata)
check_data(rdata[-c(1, 3), ])
data(survey, package = "MASS")
check_data(survey)
}
}
