/*
 * Decompiled with CFR 0.152.
 */
package core.utils;

import core.ParallelSubpopulations;
import core.Subpopulation;
import core.utils.NotAValidCompositionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class Common {
    public static double rESOLUTION = 0.01;
    public static int MAX_PM = 6;
    public static Double[] allowed_FREQUENCIES = Common.seq(0.0, 0.99, rESOLUTION);

    public static Double[] seq(double min, double max, double step) {
        Double[] d = new Double[(int)((step + max - min) / step)];
        int i = 0;
        while (i < d.length) {
            d[i] = min + (double)i * step;
            ++i;
        }
        return d;
    }

    public static <C> List<C> toList(C[] value) {
        ArrayList<C> l = new ArrayList<C>();
        C[] CArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            C d = CArray[n2];
            l.add(d);
            ++n2;
        }
        return l;
    }

    public static void setALLOWED_FREQUENCIES(double[] aLLOWED_FREQUENCIES) {
        allowed_FREQUENCIES = new Double[aLLOWED_FREQUENCIES.length];
        int i = 0;
        while (i < allowed_FREQUENCIES.length) {
            Common.allowed_FREQUENCIES[i] = aLLOWED_FREQUENCIES[i];
            ++i;
        }
    }

    public static void setMAX_PM(int max_PM) {
        MAX_PM = max_PM;
    }

    public static Double[] below(double f, Double[] a) {
        ArrayList<Double> l = new ArrayList<Double>();
        Double[] doubleArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Double d = doubleArray[n2];
            if (d <= f) {
                l.add(d);
            }
            ++n2;
        }
        return l.toArray(new Double[l.size()]);
    }

    public static Double[] above(double f, Double[] a) {
        ArrayList<Double> l = new ArrayList<Double>();
        Double[] doubleArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Double d = doubleArray[n2];
            if (d >= f) {
                l.add(d);
            }
            ++n2;
        }
        return l.toArray(new Double[l.size()]);
    }

    public static void main(String[] args) {
        try {
            ParallelSubpopulations sps = new ParallelSubpopulations(1.278829, 0.8969697, 1, true);
            Map<Double, Double> d = sps.getCellFreq2ProbabilityMap();
            Map<Subpopulation, Double> ds = sps.getSubpopulation2ProbabilityMap();
            System.out.println(sps.getBestFittingSubpopulation());
        }
        catch (NotAValidCompositionException e) {
            e.printStackTrace();
        }
    }
}

