% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{confint.spm}
\alias{confint.spm}
\title{Confidence intervals for the extremal index \eqn{\theta}}
\usage{
\method{confint}{spm}(
  object,
  parm = "theta",
  level = 0.95,
  maxima = c("sliding", "disjoint"),
  interval_type = c("norm", "lik", "both"),
  conf_scale = c("theta", "log"),
  constrain = TRUE,
  bias_adjust = TRUE,
  type = c("vertical", "cholesky", "spectral", "none"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{c("spm", "exdex")}, returned by
\code{\link{spm}}.}

\item{parm}{Specifies which parameter is to be given a confidence interval.
Here there is only one option: the extremal index \eqn{\theta}.}

\item{level}{A numeric scalar in (0, 1). The confidence level required.}

\item{maxima}{A character scalar specifying whether to estimate
confidence intervals based on sliding maxima or disjoint maxima.}

\item{interval_type}{A character scalar: \code{"norm"} for intervals of
type (a), \code{"lik"} for intervals of type (b).}

\item{conf_scale}{A character scalar.  If \code{interval_type = "norm"} then
  \code{conf_scale} determines the scale on which we use approximate
  large-sample normality of the estimators to estimate confidence intervals
  of type (a).

  If \code{conf_scale = "theta"}
  then confidence intervals are estimated for \eqn{\theta} directly.
  If \code{conf_scale = "log"} then confidence intervals are first
  estimated for \eqn{\log\theta}{log\theta} and then transformed back
  to the \eqn{\theta}-scale.

  Any bias-adjustment requested in the original call to \code{\link{spm}},
  using it's \code{bias_adjust} argument, is automatically applied here.}

\item{constrain}{A logical scalar.  If \code{constrain = TRUE} then
any confidence limits that are greater than 1 are set to 1,
that is, they are constrained to lie in (0, 1].  Otherwise,
limits that are greater than 1 may be obtained.
If \code{constrain = TRUE} then any lower confidence limits that are
less than 0 are set to 0.}

\item{bias_adjust}{A logical scalar.  If \code{bias_adjust = TRUE} then,
  if appropriate, bias-adjustment is also applied to the loglikelihood
  before it is adjusted using \code{\link[chandwich]{adjust_loglik}}.
  This is performed only if, in the call to
  \code{\link{spm}}, \code{bias_adjust = "BB3"} or
  \code{"BB1"} was specified, that is, we have
  \code{object$bias_adjust = "BB3"}
  or \code{"BB1"}.  In these cases the relevant
  component of \code{object$bias_sl} or \code{object$bias_dj}
  is used to scale \eqn{\theta} so
  that the location of the maximum of the loglikelihood lies at the
  bias-adjusted estimate of \eqn{\theta}.

  If \code{bias_adjust = FALSE} or \code{object$bias_adjust = "none"}
  or \code{"N"} then no bias-adjustment of the
  intervals is performed.  In the latter case this is because the
  bias-adjustment is applied in the creation of the data in
  \code{object$N2015_data} and \code{object$BB2018_data}, on which the
  naive likelihood is based.}

\item{type}{A character scalar.  The argument \code{type} to be passed to
\code{\link[chandwich]{conf_intervals}} in the
\code{\link[chandwich]{chandwich}} package in order to estimate the
likelihood-based intervals.
Using \code{type = "none"} is \emph{not} advised because then the
intervals are based on naive estimated standard errors.  In particular,
if (the default) \code{sliding = TRUE} was used in the call to
\code{\link{spm}} then the unadjusted likelihood-based confidence
intervals provide \emph{vast} underestimates of uncertainty.}

\item{...}{Further arguments. None are used currently.}
}
\value{
A list of class c("confint_spm", "exdex") containing the
  following components.
  \item{cis}{A matrix with columns giving the lower and upper confidence
  limits. These are labelled as (1 - level)/2 and 1 - (1 - level)/2 in
  \% (by default 2.5\% and 97.5\%).
  The row names are a concatenation of the variant of the estimator
  (\code{N2015} for Northrop (2015), \code{BB2018} for
  Berghaus and Bucher (2018)), \code{BB2018b} for the modified
  (by subtracting \code{1 / b}) Berghaus and Bucher (2018)
  and the type of interval (\code{norm} for symmetric and \code{lik} for
  likelihood-based).}
  \item{ciN}{The object returned from
    \code{\link[chandwich]{conf_intervals}} that contains information about
    the adjusted loglikelihood for the Northrop (2015) variant of the
    estimator.}
  \item{ciBB}{The object returned from
    \code{\link[chandwich]{conf_intervals}} that contains information about
    the adjusted loglikelihood for the Berghaus and Bucher (2018) variant of
    the estimator.}
  \item{ciBBb}{The object returned from
    \code{\link[chandwich]{conf_intervals}} that contains information about
    the adjusted loglikelihood for the modified Berghaus and Bucher (2018)
    variant of the estimator.}
  \item{call}{The call to \code{spm}.}
  \item{object}{The input \code{object}.}
  \item{maxima}{The input \code{maxima}.}
  \item{theta}{The relevant estimates of \eqn{\theta} returned from
    \code{\link[chandwich]{adjust_loglik}}.  These are equal to
    \code{object$theta_sl} if \code{maxima = "sliding"},
    \code{object$theta_dj} if \code{maxima = "disjoint"},
    which provides a check that the results are correct.}
  \item{level}{The input \code{level}.}
}
\description{
\code{confint} method for objects of class \code{c("spm", "exdex")}.
Computes confidence intervals for \eqn{\theta} based on an object returned
from \code{\link{spm}}.  Two types of interval may be returned:
(a) intervals that are based on approximate large-sample normality of the
estimators of \eqn{\theta} (or of \eqn{\log\theta}{log\theta} if
\code{conf_scale = "log"}), and which are symmetric about the respective
point estimates, and (b) likelihood-based intervals based on an adjustment
of a naive (pseudo-) loglikelihood, using the
\code{\link[chandwich]{adjust_loglik}} function in the
\code{\link[chandwich]{chandwich}} package.
}
\details{
The likelihood-based intervals are estimated using the
  \code{\link[chandwich]{adjust_loglik}} function in the
  \code{\link[chandwich]{chandwich}} package, followed by a call to
  \code{\link[chandwich]{conf_intervals}}.
  This adjusts the naive (pseudo-)loglikelihood so that the curvature of
  the adjust loglikelihood agrees with the estimated standard errors of
  the estimators.  The option \code{type = "none"} should not be used in
  practice because the resulting confidence intervals will be wrong.
  In particular, in the intervals based on sliding maxima will provide
  \emph{vast} underestimates of uncertainty.

  If \code{object$se} contains \code{NA}s, because the block size \code{b}
  was too small or too large in the call to \code{\link{spm}} then
  confidence intervals cannot be estimated.  A matrix of \code{NA}s
  will be returned.  See the \strong{Details} section of the
  \code{\link{spm}} documentation for more information.
}
\examples{
# Newlyn sea surges
theta <- spm(newlyn, 20)
confint(theta)
cis <- confint(theta, interval_type = "lik")
cis
plot(cis)

# S&P 500 index
theta <- spm(sp500, 100)
confint(theta)
cis <- confint(theta, interval_type = "lik")
cis
plot(cis)
}
\references{
Northrop, P. J. (2015) An efficient semiparametric maxima
estimator of the extremal index. \emph{Extremes} \strong{18}(4), 585-603.
  \doi{10.1007/s10687-015-0221-5}

Berghaus, B., Bucher, A. (2018) Weak convergence of a pseudo
  maximum likelihood estimator for the extremal index. \emph{Ann. Statist.}
  \strong{46}(5), 2307-2335. \doi{10.1214/17-AOS1621}
}
\seealso{
\code{\link{plot.confint_spm}}: \code{plot} method for
  class \code{c("confint_spm", "exdex")}.
}
