% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_columns.R
\name{rename_columns}
\alias{rename_columns}
\title{Rename columns to match standard Qualtrics names}
\usage{
rename_columns(x, alert = TRUE)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{alert}{Logical indicating whether to alert user to the fact that the
columns do not match the secondary labels and therefore cannot be renamed.}
}
\value{
An object of the same type as \code{x} that has column names that match standard
Qualtrics names.
}
\description{
The \code{rename_columns()} function renames the metadata columns to match
standard Qualtrics names.
}
\details{
When importing Qualtrics data using
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
labels entered in Qualtrics questions are saved as 'subtitles' for column
names. Using \href{https://strengejacke.github.io/sjlabelled/reference/get_label.html}{\code{sjlabelled::get_label()}}
can make these secondary labels be the
primary column names. However, this results in a different set of names for
the metadata columns than is used in all of the \code{mark_()}, \code{check_()}, and
\code{exclude_()} functions. This function renames these columns to match the
standard Qualtrics names.
}
\examples{
# Rename columns
data(qualtrics_fetch)
qualtrics_renamed <- qualtrics_fetch \%>\%
  rename_columns()
names(qualtrics_fetch)
names(qualtrics_renamed)

# Alerts when columns cannot be renamed
data(qualtrics_numeric)
rename_columns(qualtrics_numeric)

# Turn off alert
rename_columns(qualtrics_numeric, alert = FALSE)

}
\seealso{
Other column name functions: 
\code{\link{use_labels}()}
}
\concept{column name functions}
\concept{helper}
