% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{excelOutput}
\alias{excelOutput}
\title{Helper function for using jexcel table in Shiny}
\usage{
excelOutput(outputId, width = "100\%", height = "400px")
}
\arguments{
\item{outputId}{output variable to read from.}

\item{width, height}{must be a valid CSS unit in pixel or a number, which will be coerced to a string and "px" appended.}
}
\description{
Shiny bindings for excel table
}
\examples{
if(interactive()) {
  library(shiny)
  library(excelR)
  shinyApp(
    ui = fluidPage(excelOutput("table")),
    server = function(input, output, session) {
      output$table <-
     renderExcel(excelTable(data = head(iris)))
     }
   )
}
}
\seealso{
\code{\link{renderExcel}}
}
