% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xl.constants.R
\docType{data}
\name{xl.property}
\alias{xl.property}
\alias{xl.constants}
\title{Excel constants and helper function for setting Excel range properties.}
\format{An object of class \code{list} of length 2024.}
\usage{
xl.property(...)

xl.constants
}
\arguments{
\item{...}{names of arguments are properties as in Excel VBA, values are properties values.}
}
\value{
list of class \code{xl.property}.
}
\description{
\code{xl.constants} is a list with (surprise!) Excel named constants.
}
\examples{
\dontrun{
# create random matrix
rand_mat = matrix(runif(16), ncol = 4)

# put it on the new worksheet
xln[a1] = rand_mat 

# set bold font, format numbers as percent and align it
cr[a1] = xl.property(Font.Bold = TRUE, 
                     NumberFormat = "0.00\%", 
                     HorizontalAlignment = xl.constants$xlCenter
                     )
}
}
\keyword{datasets}
