% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_matrix.R
\name{html_matrix}
\alias{html_matrix}
\alias{html_mx}
\alias{html_matrix.default}
\title{HTML Representation}
\usage{
html_matrix(x, ...)

\method{html_matrix}{default}(
  x,
  ...,
  byrow = FALSE,
  numeric = list(text_align = "right"),
  integer = list(text_align = "right"),
  char = list(text_align = "left"),
  logical = list(text_align = "right"),
  border = "#999999"
)

html_mx(x, ...)
}
\arguments{
\item{x}{vector, matrix, array, table or html_matrix: input.}

\item{...}{further parameters}

\item{byrow}{logical: creates a row or column matrix if \code{x} is one-dimensional (default: \code{FALSE})}

\item{numeric}{list: of HTML style properties for a cell if \code{class(x[i,j])=="numeric"} (default: \code{list(text_align="right")})}

\item{integer}{list: of HTML style properties for a cell if \code{class(x[i,j])=="integer"} (default: \code{list(text_align="right")})}

\item{char}{list: of HTML style properties for a cell if \code{class(x[i,j])=="character"} (default: \code{list(text_align="left")})}

\item{logical}{list: of HTML style properties for a cell if \code{class(x[i,j])=="logical"} (default: \code{list(text_align="right")})}

\item{border}{character: vector of background color for a border cell (default: \code{"#999999")})}
}
\value{
Returns an \code{html_matrix}.
}
\description{
Creates from a vector, a matrix, an array, or a table, an HTML representation of it. The HTML representation has one column and one row more
than the data. The additional row and column are used in order to have a title (top left), the column names (top), and the row names (left).

You can set the style attributes (\verb{<td style="...">}) via \code{hm_cell}, \code{hm_title}, \code{hm_col}, and \code{hm_row}.
For example: \code{hm_cell(hm, 1, 1, text_align="right")} will lead to (\verb{<td style="text-align:right;">}) for the cell (1,1), and any
unnamed element will change the cell value.
Note: since \code{-} is an operator in R, we use \verb{_} instead. Of course, someone could use \code{"text-align"="right"}, but I am lazy.
}
\examples{
m <- matrix(1:6, ncol=2)
m
l <- html_matrix(m)
l
}
