% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equations.R
\name{equations}
\alias{equations}
\alias{variables}
\title{Equations and Variables}
\usage{
equations(...)

variables(...)
}
\arguments{
\item{...}{For \code{equations}, an even number of parameters: formula, LaTeX representation, formula, LaTeX representation, etc.\cr \cr
For \code{variables}, parameters to set one or more variables.}
}
\value{
(for \code{equations}) An \code{equations} object.

(for \code{variables}) The modified \code{equations} object.
}
\description{
\strong{\code{equations}} defines a set of equations using the formula interface including a LaTeX representation of the formulae.

\strong{\code{variables}} sets the variable values, the LaTeX representation and the solution interval. The first argument must be
the \code{equations} object. A named parameter starts the setting for a specific variable, e.g. \verb{..., s=1, pos(5), "s^2",...}
sets for the variable \code{s} first its numerical value, second the solution interval and finally the LaTeX representation.
}
\examples{
# The equations describe the formulae for an confidence interval of the mean
e <- equations(o~x+c*s/sqrt(n), "v_o=\\\\bar{x}+c\\\\cdot\\\\frac{s^2}{n}", 
               u~x-c*s/sqrt(n), "v_u=\\\\bar{x}-c\\\\cdot\\\\frac{s^2}{n}", 
               e~c*s/sqrt(n),   "e  =c\\\\cdot\\\\frac{s^2}{\\\\sqrt{n}}",
               l~2*e,           "l  =2\\\\cdot e"                   
               )
print(e)
e <- variables(e, 
               x=0,    "\\\\bar{x}",
               c=2.58, dbl(2), 
               s=1,    pos(5), "s^2",
               n=25,   pos(5),
               l=pos(5), 
               e=pos(5),
               u="v_u", o="v_o")
print(e)
}
