% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grade.R
\name{grade}
\alias{grade}
\alias{hu_grade}
\title{Grades}
\usage{
grade(points, maxpts = max(points), fixed = TRUE)

hu_grade(points, maxpts = max(points), fixed = TRUE)
}
\arguments{
\item{points}{numeric: points achieved in exam}

\item{maxpts}{numeric: maximal number of achievable points in an exam (default: \code{max(points)})}

\item{fixed}{logical: a fixed or relative grade scheme (default: \code{TRUE})}
}
\value{
Grades as a function of points.
}
\description{
Computes a grade based on the points of the grade scheme by the Humboldt University of Berlin. (See
§96c and §102 in the \href{https://gremien.hu-berlin.de/de/amb/2020/11/11_2020_zsp-hu_2013_ae08-2020_2020-05-29_druck.pdf#page=5}{Achte Änderung der Fächerübergreifenden Satzung zur Regelung von Zulassung, Studium und Prüfung der Humboldt-Universität zu Berlin (ZSP-HU)})
}
\examples{
x <- round(runif(100, 0, 22.4))
grade(x, 22)
}
