% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08C_BNM_GA.R
\name{BNM_PBIL}
\alias{BNM_PBIL}
\title{Structure Learning for BNM by PBIL}
\usage{
BNM_PBIL(
  U,
  Z = NULL,
  w = NULL,
  na = NULL,
  seed = 123,
  population = 20,
  Rs = 0.5,
  Rm = 0.002,
  maxParents = 2,
  maxGeneration = 100,
  successiveLimit = 5,
  elitism = 0,
  alpha = 0.05,
  estimate = 1,
  filename = NULL,
  verbose = TRUE
)
}
\arguments{
\item{U}{U is either a data class of exametrika, or raw data. When raw data is given,
it is converted to the exametrika class with the \link{dataFormat} function.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{seed}{seed for random.}

\item{population}{Population size. The default is 20}

\item{Rs}{Survival Rate. The default is 0.5}

\item{Rm}{Mutation Rate. The default is 0.002}

\item{maxParents}{Maximum number of edges emanating from a single node. The default is 2.}

\item{maxGeneration}{Maximum number of generations.}

\item{successiveLimit}{Termination conditions. If the optimal individual does not change
for this number of generations, it is considered to have converged.}

\item{elitism}{Number of elites that remain without crossover when transitioning to
the next generation.}

\item{alpha}{Learning rate. The default is 0.05}

\item{estimate}{In PBIL for estimating the adjacency matrix, specify by number from the
following four methods: 1. Optimal adjacency matrix, 2. Rounded average of individuals in
the last generation, 3. Rounded average of survivors in the last generation, 4. Rounded
generational gene of the last generation. The default is 1.}

\item{filename}{Specify the filename when saving the generated adjacency matrix in CSV format.
The default is null, and no output is written to the file.}

\item{verbose}{verbose output Flag. default is TRUE}
}
\value{
\describe{
\item{adj}{Optimal adjacency matrix}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{TestFitIndices}{Overall fit index for the test.See also \link{TestFit}}
\item{nobs}{Sample size. The number of rows in the dataset.}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{crr}{correct response ratio}
\item{TestFitIndices}{Overall fit index for the test.See also \link{TestFit}}
\item{param}{Learned Parameters}
\item{CCRR_table}{Correct Response Rate tables}
}
}
\description{
Generating a DAG from data using a Population-Based Incremental Learning
}
\details{
This function performs structural learning using the Population-Based
Incremental Learning model(PBIL) proposed by Fukuda et al.(2014) within
the genetic algorithm framework. Instead of learning the adjacency matrix
itself, the 'genes of genes' that generate the adjacency matrix are updated
with each generation. For more details, please refer to Fukuda(2014) and Section
8.5.2 of the text(Shojima,2022).
}
\examples{
\donttest{
# Perform Structure Learning for Bayesian Network Model using PBIL
# (Population-Based Incremental Learning)
BNM_PBIL(J5S10,
  population = 20, # Size of population in each generation
  Rs = 0.5, # 50\% survival rate for next generation
  Rm = 0.005, # 0.5\% mutation rate for genetic diversity
  maxParents = 2, # Maximum of 2 parent nodes per item
  alpha = 0.05, # Learning rate for probability update
  estimate = 4 # Use rounded generational gene method
)
}
}
\references{
Fukuda, S., Yamanaka, Y., & Yoshihiro, T. (2014). A Probability-based evolutionary
algorithm with mutations to learn Bayesian networks. International Journal of Artificial
Intelligence and Interactive Multimedia, 3, 7–13. DOI: 10.9781/ijimai.2014.311
}
