% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pl.R
\name{Pl}
\alias{Pl}
\title{Degree of plausibility of interval for a Gaussian random fuzzy number}
\usage{
Pl(x, y, GRFN)
}
\arguments{
\item{x}{The lower bound of the interval (may be a vector).}

\item{y}{The upper bound of the interval (may be a vector).}

\item{GRFN}{A Gaussian random fuzzy number, encoded as a list with components mu, sig
and h.}
}
\value{
The degree of plausibility of the interval.
}
\description{
\code{Pl} computes the degree of plausibility of an interval [x,y] for a given Gaussian
random fuzzy number.
}
\examples{
pl<-Pl(1,2,list(mu=2,sig=1,h=2))
print(pl)
}
\references{
Thierry Denoeux. Reasoning with fuzzy and uncertain evidence using epistemic random
fuzzy sets: general framework and practical models. Fuzzy Sets and Systems, Vol. 453,
Pages 1-36, 2023.
}
\seealso{
\code{\link{Belint}}, \code{\link{Bel}}, \code{\link{pl_contour}},
\code{\link{combination_GRFN}}
}
