% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netlogo-helper.R
\name{NLWrapper.GetParameter}
\alias{NLWrapper.GetParameter}
\title{NLWrapper.GetParameter}
\usage{
NLWrapper.GetParameter(obj, name)
}
\arguments{
\item{obj}{The object retuned by \link{NLWrapper.Model}}

\item{name}{The parameter name string or the collection of parameter names}
}
\value{
The parameter values
}
\description{
Gets the value of a model parameter
}
\examples{
\dontrun{
   rm(list=ls())
   p<- "C:/Program Files/NetLogo 6.0.4/app"
   m<- file.path(nlpath, "models", "Sample Models", "Biology", "Wolf Sheep Predation.nlogo")
   o<- NLWrapper.Model(p, m)
   v<- NLWrapper.GetParameter(o, c("initial-number-sheep"))

   or

   v<- NLWrapper.GetParameter(o, c("initial-number-sheep","initial-number-wolves")))
}

}
