% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.evoTS.multi.OU.fit.R
\name{as.evoTS.multi.OU.fit}
\alias{as.evoTS.multi.OU.fit}
\title{Class for fit to evolutionary sequence (time-series) models}
\usage{
as.evoTS.multi.OU.fit(
  converge,
  logL,
  ancestral.values,
  SE.anc,
  optima,
  SE.optima,
  A,
  SE.A,
  half.life,
  R,
  SE.R,
  method,
  K,
  n,
  iter
)
}
\arguments{
\item{converge}{info on model convergence}

\item{logL}{log-likelihood of model}

\item{ancestral.values}{maximum-likelihood estimates of the ancestral trait values}

\item{SE.anc}{standard errors of the estimated ancestral states}

\item{optima}{maximum-likelihood estimates of the optima}

\item{SE.optima}{standard errors of the estimated optimal trait values}

\item{A}{maximum-likelihood estimates of the parameters in the A matrix}

\item{SE.A}{standard errors of the estimated A matrix}

\item{half.life}{the calculated half-life of the evolutionary process}

\item{R}{maximum-likelihood estimates of the parameters in the R matrix}

\item{SE.R}{standard errors of the parameters in the R matrix}

\item{method}{the parameterization used: Joint}

\item{K}{number of parameters in the model}

\item{n}{sample size}

\item{iter}{the number of times the optimization method is run from different starting points. Default is NULL, meaning the optimization is run once.}
}
\description{
A function that combines useful information summarizing model fit.
}
\details{
This function is used by the model-fitting routines for the multivariate Ornstein-Uhlenbeck models to create standardized output
}
\note{
This function is not likely to be called directly by the user.
}
\author{
Kjetil Lysne Voje
}
