% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dgammagpd.r
\name{gammagpd}
\alias{dgammagpd}
\alias{gammagpd}
\alias{pgammagpd}
\alias{qgammagpd}
\alias{rgammagpd}
\title{Gamma Bulk and GPD Tail Extreme Value Mixture Model}
\usage{
dgammagpd(x, gshape = 1, gscale = 1, u = qgamma(0.9, gshape, 1/gscale),
  sigmau = sqrt(gshape) * gscale, xi = 0, phiu = TRUE, log = FALSE)

pgammagpd(q, gshape = 1, gscale = 1, u = qgamma(0.9, gshape, 1/gscale),
  sigmau = sqrt(gshape) * gscale, xi = 0, phiu = TRUE,
  lower.tail = TRUE)

qgammagpd(p, gshape = 1, gscale = 1, u = qgamma(0.9, gshape, 1/gscale),
  sigmau = sqrt(gshape) * gscale, xi = 0, phiu = TRUE,
  lower.tail = TRUE)

rgammagpd(n = 1, gshape = 1, gscale = 1, u = qgamma(0.9, gshape,
  1/gscale), sigmau = sqrt(gshape) * gscale, xi = 0, phiu = TRUE)
}
\arguments{
\item{x}{quantiles}

\item{gshape}{gamma shape (positive)}

\item{gscale}{gamma scale (positive)}

\item{u}{threshold}

\item{sigmau}{scale parameter (positive)}

\item{xi}{shape parameter}

\item{phiu}{probability of being above threshold \eqn{[0, 1]} or \code{TRUE}}

\item{log}{logical, if TRUE then log density}

\item{q}{quantiles}

\item{lower.tail}{logical, if FALSE then upper tail probabilities}

\item{p}{cumulative probabilities}

\item{n}{sample size (positive integer)}
}
\value{
\code{\link[evmix:gammagpd]{dgammagpd}} gives the density,
\code{\link[evmix:gammagpd]{pgammagpd}} gives the cumulative distribution function,
\code{\link[evmix:gammagpd]{qgammagpd}} gives the quantile function and
\code{\link[evmix:gammagpd]{rgammagpd}} gives a random sample.
}
\description{
Density, cumulative distribution function, quantile function and
  random number generation for the extreme value mixture model with gamma for bulk
  distribution upto the threshold and conditional GPD above threshold. The parameters
  are the gamma shape \code{gshape} and scale \code{gscale}, threshold \code{u}
  GPD scale \code{sigmau} and shape \code{xi} and tail fraction \code{phiu}.
}
\details{
Extreme value mixture model combining gamma distribution for the bulk
below the threshold and GPD for upper tail.

The user can pre-specify \code{phiu}
permitting a parameterised value for the tail fraction \eqn{\phi_u}. Alternatively, when
\code{phiu=TRUE} the tail fraction is estimated as the tail fraction from the
gamma bulk model.

The cumulative distribution function with tail fraction \eqn{\phi_u} defined by the
upper tail fraction of the gamma bulk model (\code{phiu=TRUE}), upto the
threshold \eqn{0 < x \le u}, given by:
\deqn{F(x) = H(x)}
and above the threshold \eqn{x > u}:
\deqn{F(x) = H(u) + [1 - H(u)] G(x)}
where \eqn{H(x)} and \eqn{G(X)} are the gamma and conditional GPD
cumulative distribution functions (i.e. \code{pgamma(x, gshape, 1/gscale)} and
\code{pgpd(x, u, sigmau, xi)}) respectively.

The cumulative distribution function for pre-specified \eqn{\phi_u}, upto the
threshold \eqn{0 < x \le u}, is given by:
\deqn{F(x) = (1 - \phi_u) H(x)/H(u)}
and above the threshold \eqn{x > u}:
\deqn{F(x) = \phi_u + [1 - \phi_u] G(x)}
Notice that these definitions are equivalent when \eqn{\phi_u = 1 - H(u)}.

The gamma is defined on the non-negative reals, so the threshold must be positive.
Though behaviour at zero depends on the shape (\eqn{\alpha}):
\itemize{
 \item \eqn{f(0+)=\infty} for \eqn{0<\alpha<1};
 \item \eqn{f(0+)=1/\beta} for \eqn{\alpha=1} (exponential);
 \item \eqn{f(0+)=0} for \eqn{\alpha>1};
}
where \eqn{\beta} is the scale parameter.

See \code{\link[evmix:gpd]{gpd}} for details of GPD upper tail component and
\code{\link[stats:GammaDist]{dgamma}} for details of gamma bulk component.
}
\note{
All inputs are vectorised except \code{log} and \code{lower.tail}.
The main inputs (\code{x}, \code{p} or \code{q}) and parameters must be either
a scalar or a vector. If vectors are provided they must all be of the same length,
and the function will be evaluated for each element of vector. In the case of
\code{\link[evmix:gammagpd]{rgammagpd}} any input vector must be of length \code{n}.

Default values are provided for all inputs, except for the fundamentals
\code{x}, \code{q} and \code{p}. The default sample size for
\code{\link[evmix:gammagpd]{rgammagpd}} is 1.

Missing (\code{NA}) and Not-a-Number (\code{NaN}) values in \code{x},
\code{p} and \code{q} are passed through as is and infinite values are set to
\code{NA}. None of these are not permitted for the parameters.

Error checking of the inputs (e.g. invalid probabilities) is carried out and
will either stop or give warning message as appropriate.
}
\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 2))

x = rgammagpd(1000, gshape = 2)
xx = seq(-1, 10, 0.01)
hist(x, breaks = 100, freq = FALSE, xlim = c(-1, 10))
lines(xx, dgammagpd(xx, gshape = 2))

# three tail behaviours
plot(xx, pgammagpd(xx, gshape = 2), type = "l")
lines(xx, pgammagpd(xx, gshape = 2, xi = 0.3), col = "red")
lines(xx, pgammagpd(xx, gshape = 2, xi = -0.3), col = "blue")
legend("bottomright", paste("xi =",c(0, 0.3, -0.3)),
  col=c("black", "red", "blue"), lty = 1)

x = rgammagpd(1000, gshape = 2, u = 3, phiu = 0.2)
hist(x, breaks = 100, freq = FALSE, xlim = c(-1, 10))
lines(xx, dgammagpd(xx, gshape = 2, u = 3, phiu = 0.2))

plot(xx, dgammagpd(xx, gshape = 2, u = 3, xi=0, phiu = 0.2), type = "l")
lines(xx, dgammagpd(xx, gshape = 2, u = 3, xi=-0.2, phiu = 0.2), col = "red")
lines(xx, dgammagpd(xx, gshape = 2, u = 3, xi=0.2, phiu = 0.2), col = "blue")
legend("topright", c("xi = 0", "xi = 0.2", "xi = -0.2"),
  col=c("black", "red", "blue"), lty = 1)
}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://en.wikipedia.org/wiki/Gamma_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Behrens, C.N., Lopes, H.F. and Gamerman, D. (2004). Bayesian analysis of extreme
events with threshold estimation. Statistical Modelling. 4(3), 227-244.
}
\seealso{
\code{\link[evmix:gpd]{gpd}} and \code{\link[stats:GammaDist]{dgamma}}

Other mgamma fmgamma
         gammagpd gammagpdcon fgammagpd fgammagpdcon normgpd fnormgpd
         mgammagpd mgammagpdcon fmgammagpd fmgammagpdcon: \code{\link{dgammagpdcon}},
  \code{\link{dgammagpdcon}}, \code{\link{dgammagpdcon}},
  \code{\link{dgammagpdcon}}, \code{\link{dgammagpdcon}},
  \code{\link{gammagpdcon}}, \code{\link{gammagpdcon}},
  \code{\link{gammagpdcon}}, \code{\link{gammagpdcon}},
  \code{\link{gammagpdcon}}, \code{\link{pgammagpdcon}},
  \code{\link{pgammagpdcon}}, \code{\link{pgammagpdcon}},
  \code{\link{pgammagpdcon}}, \code{\link{pgammagpdcon}},
  \code{\link{qgammagpdcon}}, \code{\link{qgammagpdcon}},
  \code{\link{qgammagpdcon}}, \code{\link{qgammagpdcon}},
  \code{\link{qgammagpdcon}}, \code{\link{rgammagpdcon}},
  \code{\link{rgammagpdcon}}, \code{\link{rgammagpdcon}},
  \code{\link{rgammagpdcon}}, \code{\link{rgammagpdcon}};
  \code{\link{dmgammagpdcon}}, \code{\link{dmgammagpdcon}},
  \code{\link{dmgammagpdcon}}, \code{\link{dmgammagpdcon}},
  \code{\link{dmgammagpdcon}}, \code{\link{mgammagpdcon}},
  \code{\link{mgammagpdcon}}, \code{\link{mgammagpdcon}},
  \code{\link{mgammagpdcon}}, \code{\link{mgammagpdcon}},
  \code{\link{pmgammagpdcon}}, \code{\link{pmgammagpdcon}},
  \code{\link{pmgammagpdcon}}, \code{\link{pmgammagpdcon}},
  \code{\link{pmgammagpdcon}}, \code{\link{qmgammagpdcon}},
  \code{\link{qmgammagpdcon}}, \code{\link{qmgammagpdcon}},
  \code{\link{qmgammagpdcon}}, \code{\link{qmgammagpdcon}},
  \code{\link{rmgammagpdcon}}, \code{\link{rmgammagpdcon}},
  \code{\link{rmgammagpdcon}}, \code{\link{rmgammagpdcon}},
  \code{\link{rmgammagpdcon}}; \code{\link{dmgammagpd}},
  \code{\link{dmgammagpd}}, \code{\link{dmgammagpd}},
  \code{\link{dmgammagpd}}, \code{\link{dmgammagpd}},
  \code{\link{mgammagpd}}, \code{\link{mgammagpd}},
  \code{\link{mgammagpd}}, \code{\link{mgammagpd}},
  \code{\link{mgammagpd}}, \code{\link{pmgammagpd}},
  \code{\link{pmgammagpd}}, \code{\link{pmgammagpd}},
  \code{\link{pmgammagpd}}, \code{\link{pmgammagpd}},
  \code{\link{qmgammagpd}}, \code{\link{qmgammagpd}},
  \code{\link{qmgammagpd}}, \code{\link{qmgammagpd}},
  \code{\link{qmgammagpd}}, \code{\link{rmgammagpd}},
  \code{\link{rmgammagpd}}, \code{\link{rmgammagpd}},
  \code{\link{rmgammagpd}}, \code{\link{rmgammagpd}};
  \code{\link{dmgamma}}, \code{\link{dmgamma}},
  \code{\link{dmgamma}}, \code{\link{dmgamma}},
  \code{\link{dmgamma}}, \code{\link{mgamma}},
  \code{\link{mgamma}}, \code{\link{mgamma}},
  \code{\link{mgamma}}, \code{\link{mgamma}},
  \code{\link{pmgamma}}, \code{\link{pmgamma}},
  \code{\link{pmgamma}}, \code{\link{pmgamma}},
  \code{\link{pmgamma}}, \code{\link{qmgamma}},
  \code{\link{qmgamma}}, \code{\link{qmgamma}},
  \code{\link{qmgamma}}, \code{\link{qmgamma}},
  \code{\link{rmgamma}}, \code{\link{rmgamma}},
  \code{\link{rmgamma}}, \code{\link{rmgamma}},
  \code{\link{rmgamma}}; \code{\link{fgammagpdcon}},
  \code{\link{fgammagpdcon}}, \code{\link{fgammagpdcon}},
  \code{\link{fgammagpdcon}}, \code{\link{fgammagpdcon}},
  \code{\link{lgammagpdcon}}, \code{\link{lgammagpdcon}},
  \code{\link{lgammagpdcon}}, \code{\link{lgammagpdcon}},
  \code{\link{lgammagpdcon}}, \code{\link{nlgammagpdcon}},
  \code{\link{nlgammagpdcon}}, \code{\link{nlgammagpdcon}},
  \code{\link{nlgammagpdcon}}, \code{\link{nlgammagpdcon}},
  \code{\link{nlugammagpdcon}},
  \code{\link{nlugammagpdcon}},
  \code{\link{nlugammagpdcon}},
  \code{\link{nlugammagpdcon}},
  \code{\link{nlugammagpdcon}},
  \code{\link{proflugammagpdcon}},
  \code{\link{proflugammagpdcon}},
  \code{\link{proflugammagpdcon}},
  \code{\link{proflugammagpdcon}},
  \code{\link{proflugammagpdcon}}; \code{\link{fgammagpd}},
  \code{\link{fgammagpd}}, \code{\link{fgammagpd}},
  \code{\link{fgammagpd}}, \code{\link{fgammagpd}},
  \code{\link{lgammagpd}}, \code{\link{lgammagpd}},
  \code{\link{lgammagpd}}, \code{\link{lgammagpd}},
  \code{\link{lgammagpd}}, \code{\link{nlgammagpd}},
  \code{\link{nlgammagpd}}, \code{\link{nlgammagpd}},
  \code{\link{nlgammagpd}}, \code{\link{nlgammagpd}},
  \code{\link{nlugammagpd}}, \code{\link{nlugammagpd}},
  \code{\link{nlugammagpd}}, \code{\link{nlugammagpd}},
  \code{\link{nlugammagpd}}, \code{\link{proflugammagpd}},
  \code{\link{proflugammagpd}},
  \code{\link{proflugammagpd}},
  \code{\link{proflugammagpd}},
  \code{\link{proflugammagpd}};
  \code{\link{fmgammagpdcon}}, \code{\link{fmgammagpdcon}},
  \code{\link{fmgammagpdcon}}, \code{\link{fmgammagpdcon}},
  \code{\link{fmgammagpdcon}}, \code{\link{fmgammagpdcon}},
  \code{\link{fmgammagpdcon}}, \code{\link{lmgammagpdcon}},
  \code{\link{lmgammagpdcon}}, \code{\link{lmgammagpdcon}},
  \code{\link{lmgammagpdcon}}, \code{\link{lmgammagpdcon}},
  \code{\link{lmgammagpdcon}}, \code{\link{lmgammagpdcon}},
  \code{\link{nlEMmgammagpdcon}},
  \code{\link{nlEMmgammagpdcon}},
  \code{\link{nlEMmgammagpdcon}},
  \code{\link{nlEMmgammagpdcon}},
  \code{\link{nlEMmgammagpdcon}},
  \code{\link{nlEMmgammagpdcon}},
  \code{\link{nlEMmgammagpdcon}},
  \code{\link{nlmgammagpdcon}},
  \code{\link{nlmgammagpdcon}},
  \code{\link{nlmgammagpdcon}},
  \code{\link{nlmgammagpdcon}},
  \code{\link{nlmgammagpdcon}},
  \code{\link{nlmgammagpdcon}},
  \code{\link{nlmgammagpdcon}},
  \code{\link{nluEMmgammagpdcon}},
  \code{\link{nluEMmgammagpdcon}},
  \code{\link{nluEMmgammagpdcon}},
  \code{\link{nluEMmgammagpdcon}},
  \code{\link{nluEMmgammagpdcon}},
  \code{\link{nluEMmgammagpdcon}},
  \code{\link{nluEMmgammagpdcon}},
  \code{\link{nlumgammagpdcon}},
  \code{\link{nlumgammagpdcon}},
  \code{\link{nlumgammagpdcon}},
  \code{\link{nlumgammagpdcon}},
  \code{\link{nlumgammagpdcon}},
  \code{\link{nlumgammagpdcon}},
  \code{\link{nlumgammagpdcon}},
  \code{\link{proflumgammagpdcon}},
  \code{\link{proflumgammagpdcon}},
  \code{\link{proflumgammagpdcon}},
  \code{\link{proflumgammagpdcon}},
  \code{\link{proflumgammagpdcon}},
  \code{\link{proflumgammagpdcon}},
  \code{\link{proflumgammagpdcon}};
  \code{\link{fmgammagpd}}, \code{\link{fmgammagpd}},
  \code{\link{fmgammagpd}}, \code{\link{fmgammagpd}},
  \code{\link{fmgammagpd}}, \code{\link{fmgammagpd}},
  \code{\link{fmgammagpd}}, \code{\link{lmgammagpd}},
  \code{\link{lmgammagpd}}, \code{\link{lmgammagpd}},
  \code{\link{lmgammagpd}}, \code{\link{lmgammagpd}},
  \code{\link{lmgammagpd}}, \code{\link{lmgammagpd}},
  \code{\link{nlEMmgammagpd}}, \code{\link{nlEMmgammagpd}},
  \code{\link{nlEMmgammagpd}}, \code{\link{nlEMmgammagpd}},
  \code{\link{nlEMmgammagpd}}, \code{\link{nlEMmgammagpd}},
  \code{\link{nlEMmgammagpd}}, \code{\link{nlmgammagpd}},
  \code{\link{nlmgammagpd}}, \code{\link{nlmgammagpd}},
  \code{\link{nlmgammagpd}}, \code{\link{nlmgammagpd}},
  \code{\link{nlmgammagpd}}, \code{\link{nlmgammagpd}},
  \code{\link{nluEMmgammagpd}},
  \code{\link{nluEMmgammagpd}},
  \code{\link{nluEMmgammagpd}},
  \code{\link{nluEMmgammagpd}},
  \code{\link{nluEMmgammagpd}},
  \code{\link{nluEMmgammagpd}},
  \code{\link{nluEMmgammagpd}}, \code{\link{nlumgammagpd}},
  \code{\link{nlumgammagpd}}, \code{\link{nlumgammagpd}},
  \code{\link{nlumgammagpd}}, \code{\link{nlumgammagpd}},
  \code{\link{nlumgammagpd}}, \code{\link{nlumgammagpd}},
  \code{\link{proflumgammagpd}},
  \code{\link{proflumgammagpd}},
  \code{\link{proflumgammagpd}},
  \code{\link{proflumgammagpd}},
  \code{\link{proflumgammagpd}},
  \code{\link{proflumgammagpd}},
  \code{\link{proflumgammagpd}}; \code{\link{fmgamma}},
  \code{\link{fmgamma}}, \code{\link{fmgamma}},
  \code{\link{fmgamma}}, \code{\link{lmgamma}},
  \code{\link{lmgamma}}, \code{\link{lmgamma}},
  \code{\link{lmgamma}}, \code{\link{nlEMmgamma}},
  \code{\link{nlEMmgamma}}, \code{\link{nlEMmgamma}},
  \code{\link{nlEMmgamma}}, \code{\link{nlmgamma}},
  \code{\link{nlmgamma}}, \code{\link{nlmgamma}},
  \code{\link{nlmgamma}}
}

