% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createD.R
\name{createD}
\alias{createD}
\title{Computation of a  Euclidean distance matrix}
\usage{
createD(x, k)
}
\arguments{
\item{x}{n x p data matrix.}

\item{k}{Number of distances. If missing, an n x n distance matrix is computed.}
}
\value{
A list with two elemnents:
\describe{
\item{D}{n x k distance matrix.}
\item{J}{n x k matrix of indices. D[i,j] is the Euclidean distance between x[i,] and
x[J[i,j],].}
}
}
\description{
\code{createD} constructs an n x k matrix of Euclidean distances from an n x p matrix
of attribute data. For each object, the distances to k randomly selected objects are
computed.
}
\examples{
data(fourclass)
x<-as.matrix(fourclass[,1:2])
dist<-createD(x,k=10)
dim(dist$D)
dim(dist$J)

}
\seealso{
\code{\link{kevclus}}
}

